/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate;

import java.util.List;
import java.util.Objects;
import me.lucko.luckperms.common.bulkupdate.DataType;
import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.action.Action;
import me.lucko.luckperms.common.bulkupdate.query.Query;
import net.luckperms.api.node.Node;

public final class BulkUpdate {
    private final DataType dataType;
    private final Action action;
    private final List<Query> queries;

    public BulkUpdate(DataType dataType, Action action, List<Query> queries) {
        this.dataType = dataType;
        this.action = action;
        this.queries = queries;
    }

    public boolean satisfiesConstraints(Node node) {
        for (Query query : this.queries) {
            if (query.isSatisfiedBy(node)) continue;
            return false;
        }
        return true;
    }

    public Node apply(Node from) {
        if (!this.satisfiesConstraints(from)) {
            return from;
        }
        return this.action.apply(from);
    }

    public PreparedStatementBuilder buildAsSql() {
        PreparedStatementBuilder builder = new PreparedStatementBuilder();
        this.action.appendSql(builder);
        if (this.queries.isEmpty()) {
            return builder;
        }
        builder.append(" WHERE");
        for (int i = 0; i < this.queries.size(); ++i) {
            Query query = this.queries.get(i);
            builder.append(" ");
            if (i != 0) {
                builder.append("AND ");
            }
            query.appendSql(builder);
        }
        return builder;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Action getAction() {
        return this.action;
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkUpdate)) {
            return false;
        }
        BulkUpdate that = (BulkUpdate)o;
        return this.getDataType() == that.getDataType() && Objects.equals(this.getAction(), that.getAction()) && Objects.equals(this.getQueries(), that.getQueries());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getDataType(), this.getAction(), this.getQueries()});
    }

    public String toString() {
        return "BulkUpdate(dataType=" + (Object)((Object)this.getDataType()) + ", action=" + this.getAction() + ", constraints=" + this.getQueries() + ")";
    }
}

