/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate.action;

import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.action.Action;
import me.lucko.luckperms.common.bulkupdate.query.QueryField;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.node.Node;

public class UpdateAction
implements Action {
    private final QueryField field;
    private final String value;

    public static UpdateAction of(QueryField field, String value) {
        return new UpdateAction(field, value);
    }

    private UpdateAction(QueryField field, String value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public String getName() {
        return "update";
    }

    @Override
    public Node apply(Node from) {
        switch (this.field) {
            case PERMISSION: {
                return NodeBuilders.determineMostApplicable(this.value).value(from.getValue()).expiry(from.getExpiry()).context(from.getContexts()).build();
            }
            case SERVER: {
                MutableContextSet contexts = from.getContexts().mutableCopy();
                contexts.removeAll("server");
                if (!this.value.equals("global")) {
                    contexts.add("server", this.value);
                }
                return from.toBuilder().context(contexts).build();
            }
            case WORLD: {
                MutableContextSet contexts = from.getContexts().mutableCopy();
                contexts.removeAll("world");
                if (!this.value.equals("global")) {
                    contexts.add("world", this.value);
                }
                return from.toBuilder().context(contexts).build();
            }
        }
        throw new RuntimeException();
    }

    @Override
    public void appendSql(PreparedStatementBuilder builder) {
        builder.append("UPDATE {table} SET " + this.field.getSqlName() + "=?");
        builder.variable(this.value);
    }
}

