/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cache;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class MRUCache<T> {
    private volatile T recent;
    private final AtomicInteger modCount = new AtomicInteger();

    protected int modCount() {
        return this.modCount.get();
    }

    protected T getRecent() {
        return this.recent;
    }

    protected void offerRecent(int validAt, T offer) {
        if (validAt == this.modCount.get()) {
            this.recent = offer;
        }
    }

    protected void clearRecent() {
        this.recent = null;
        this.modCount.incrementAndGet();
    }
}

