/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.cache.MRUCache;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.cacheddata.type.MetaCache;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.metastacking.SimpleMetaStack;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.AsyncLoadingCache;
import me.lucko.luckperms.lib.caffeine.cache.CacheLoader;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCachedDataManager
implements CachedDataManager {
    private final LuckPermsPlugin plugin;
    private final Permission permissionDataManager;
    private final Meta metaDataManager;

    protected AbstractCachedDataManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.permissionDataManager = new Permission();
        this.metaDataManager = new Meta();
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public @NonNull CachedDataManager.Container<CachedPermissionData> permissionData() {
        return this.permissionDataManager;
    }

    @Override
    public @NonNull CachedDataManager.Container<CachedMetaData> metaData() {
        return this.metaDataManager;
    }

    @Override
    public @NonNull PermissionCache getPermissionData(@NonNull QueryOptions queryOptions) {
        return this.permissionDataManager.get(queryOptions);
    }

    @Override
    public @NonNull MetaCache getMetaData(@NonNull QueryOptions queryOptions) {
        return this.metaDataManager.get(queryOptions);
    }

    @Override
    public @NonNull PermissionCache getPermissionData() {
        return this.getPermissionData(this.getQueryOptions());
    }

    @Override
    public @NonNull MetaCache getMetaData() {
        return this.getMetaData(this.getQueryOptions());
    }

    protected abstract CacheMetadata getMetadataForQueryOptions(QueryOptions var1);

    protected abstract QueryOptions getQueryOptions();

    protected abstract CalculatorFactory getCalculatorFactory();

    protected abstract MetaStackDefinition getDefaultMetaStackDefinition(ChatMetaType var1);

    protected abstract Map<String, Boolean> resolvePermissions(QueryOptions var1);

    protected abstract void resolveMeta(MetaAccumulator var1, QueryOptions var2);

    private PermissionCache calculatePermissions(QueryOptions queryOptions, PermissionCache data) {
        Objects.requireNonNull(queryOptions, "queryOptions");
        if (data == null) {
            CacheMetadata metadata = this.getMetadataForQueryOptions(queryOptions);
            data = new PermissionCache(queryOptions, metadata, this.getCalculatorFactory());
        }
        data.setPermissions(this.resolvePermissions(queryOptions));
        return data;
    }

    private MetaCache calculateMeta(QueryOptions queryOptions, MetaCache data) {
        Objects.requireNonNull(queryOptions, "queryOptions");
        if (data == null) {
            CacheMetadata metadata = this.getMetadataForQueryOptions(queryOptions);
            data = new MetaCache(this.plugin, queryOptions, metadata);
        }
        MetaAccumulator accumulator = this.newAccumulator(queryOptions);
        this.resolveMeta(accumulator, queryOptions);
        data.loadMeta(accumulator);
        return data;
    }

    @Override
    public final void invalidate() {
        this.permissionDataManager.invalidate();
        this.metaDataManager.invalidate();
    }

    @Override
    public final void invalidatePermissionCalculators() {
        this.permissionDataManager.cache.synchronous().asMap().values().forEach(PermissionCache::invalidateCache);
    }

    public final void performCacheCleanup() {
        this.permissionDataManager.cache.synchronous().cleanUp();
        this.metaDataManager.cache.synchronous().cleanUp();
    }

    private static boolean isReady(@Nullable CompletableFuture<?> future) {
        return future != null && future.isDone() && !future.isCompletedExceptionally() && future.join() != null;
    }

    private static <V> V getIfReady(@Nullable CompletableFuture<V> future) {
        return AbstractCachedDataManager.isReady(future) ? (V)future.join() : null;
    }

    private MetaStackDefinition getMetaStackDefinition(QueryOptions queryOptions, ChatMetaType type) {
        MetaStackDefinition stack = queryOptions.option(type == ChatMetaType.PREFIX ? MetaStackDefinition.PREFIX_STACK_KEY : MetaStackDefinition.SUFFIX_STACK_KEY).orElse(null);
        if (stack == null) {
            stack = this.getDefaultMetaStackDefinition(type);
        }
        return stack;
    }

    private MetaAccumulator newAccumulator(QueryOptions queryOptions) {
        return new MetaAccumulator(new SimpleMetaStack(this.getMetaStackDefinition(queryOptions, ChatMetaType.PREFIX), ChatMetaType.PREFIX), new SimpleMetaStack(this.getMetaStackDefinition(queryOptions, ChatMetaType.SUFFIX), ChatMetaType.SUFFIX));
    }

    private static final class RecentMetaData {
        final QueryOptions queryOptions;
        final MetaCache metaData;

        RecentMetaData(QueryOptions queryOptions, MetaCache metaData) {
            this.queryOptions = queryOptions;
            this.metaData = metaData;
        }
    }

    private static final class RecentPermissionData {
        final QueryOptions queryOptions;
        final PermissionCache permissionData;

        RecentPermissionData(QueryOptions queryOptions, PermissionCache permissionData) {
            this.queryOptions = queryOptions;
            this.permissionData = permissionData;
        }
    }

    private final class MetaCacheLoader
    implements CacheLoader<QueryOptions, MetaCache> {
        private MetaCacheLoader() {
        }

        public MetaCache load(@NonNull QueryOptions queryOptions) {
            return AbstractCachedDataManager.this.calculateMeta(queryOptions, null);
        }

        public MetaCache reload(@NonNull QueryOptions queryOptions, @NonNull MetaCache oldData) {
            return AbstractCachedDataManager.this.calculateMeta(queryOptions, oldData);
        }
    }

    private final class PermissionCacheLoader
    implements CacheLoader<QueryOptions, PermissionCache> {
        private PermissionCacheLoader() {
        }

        public PermissionCache load(@NonNull QueryOptions queryOptions) {
            return AbstractCachedDataManager.this.calculatePermissions(queryOptions, null);
        }

        public PermissionCache reload(@NonNull QueryOptions queryOptions, @NonNull PermissionCache oldData) {
            return AbstractCachedDataManager.this.calculatePermissions(queryOptions, oldData);
        }
    }

    private final class Meta
    extends MRUCache<RecentMetaData>
    implements CachedDataManager.Container<CachedMetaData> {
        private final AsyncLoadingCache<QueryOptions, MetaCache> cache;

        private Meta() {
            this.cache = CaffeineFactory.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).buildAsync((CacheLoader)new MetaCacheLoader());
        }

        @Override
        public @NonNull MetaCache get(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            RecentMetaData recent = (RecentMetaData)this.getRecent();
            if (recent != null && queryOptions.equals(recent.queryOptions)) {
                return recent.metaData;
            }
            int modCount = this.modCount();
            MetaCache data = (MetaCache)this.cache.synchronous().get((Object)queryOptions);
            this.offerRecent(modCount, new RecentMetaData(queryOptions, data));
            return data;
        }

        @Override
        public @NonNull MetaCache calculate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            return AbstractCachedDataManager.this.calculateMeta(queryOptions, null);
        }

        @Override
        public void recalculate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            this.cache.synchronous().refresh((Object)queryOptions);
            this.clearRecent();
        }

        @Override
        public @NonNull CompletableFuture<? extends MetaCache> reload(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            CompletableFuture previous = this.cache.getIfPresent((Object)queryOptions);
            this.cache.synchronous().invalidate((Object)queryOptions);
            this.clearRecent();
            MetaCache value = (MetaCache)AbstractCachedDataManager.getIfReady(previous);
            if (value != null) {
                return this.cache.get((Object)queryOptions, c -> AbstractCachedDataManager.this.calculateMeta(c, value));
            }
            return this.cache.get((Object)queryOptions);
        }

        @Override
        public void recalculate() {
            Set keys = this.cache.synchronous().asMap().keySet();
            keys.forEach(this::recalculate);
        }

        @Override
        public @NonNull CompletableFuture<Void> reload() {
            Set keys = this.cache.synchronous().asMap().keySet();
            return CompletableFuture.allOf((CompletableFuture[])keys.stream().map(this::reload).toArray(CompletableFuture[]::new));
        }

        @Override
        public void invalidate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            this.cache.synchronous().invalidate((Object)queryOptions);
            this.clearRecent();
        }

        @Override
        public void invalidate() {
            this.cache.synchronous().invalidateAll();
            this.clearRecent();
        }
    }

    private final class Permission
    extends MRUCache<RecentPermissionData>
    implements CachedDataManager.Container<CachedPermissionData> {
        private final AsyncLoadingCache<QueryOptions, PermissionCache> cache;

        private Permission() {
            this.cache = CaffeineFactory.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).buildAsync((CacheLoader)new PermissionCacheLoader());
        }

        @Override
        public @NonNull PermissionCache get(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            RecentPermissionData recent = (RecentPermissionData)this.getRecent();
            if (recent != null && queryOptions.equals(recent.queryOptions)) {
                return recent.permissionData;
            }
            int modCount = this.modCount();
            PermissionCache data = (PermissionCache)this.cache.synchronous().get((Object)queryOptions);
            this.offerRecent(modCount, new RecentPermissionData(queryOptions, data));
            return data;
        }

        @Override
        public @NonNull PermissionCache calculate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            return AbstractCachedDataManager.this.calculatePermissions(queryOptions, null);
        }

        @Override
        public void recalculate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            this.cache.synchronous().refresh((Object)queryOptions);
            this.clearRecent();
        }

        @Override
        public @NonNull CompletableFuture<? extends PermissionCache> reload(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            CompletableFuture previous = this.cache.getIfPresent((Object)queryOptions);
            this.cache.synchronous().invalidate((Object)queryOptions);
            this.clearRecent();
            PermissionCache value = (PermissionCache)AbstractCachedDataManager.getIfReady(previous);
            if (value != null) {
                return this.cache.get((Object)queryOptions, c -> AbstractCachedDataManager.this.calculatePermissions(c, value));
            }
            return this.cache.get((Object)queryOptions);
        }

        @Override
        public void recalculate() {
            Set keys = this.cache.synchronous().asMap().keySet();
            keys.forEach(this::recalculate);
        }

        @Override
        public @NonNull CompletableFuture<Void> reload() {
            Set keys = this.cache.synchronous().asMap().keySet();
            return CompletableFuture.allOf((CompletableFuture[])keys.stream().map(this::reload).toArray(CompletableFuture[]::new));
        }

        @Override
        public void invalidate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            this.cache.synchronous().invalidate((Object)queryOptions);
            this.clearRecent();
        }

        @Override
        public void invalidate() {
            this.cache.synchronous().invalidateAll();
            this.clearRecent();
        }
    }
}

