/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import com.google.common.collect.ForwardingMap;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.cacheddata.type.SimpleMetaCache;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MetaCache
extends SimpleMetaCache
implements CachedMetaData {
    private final LuckPermsPlugin plugin;
    private final CacheMetadata metadata;
    private final String verboseCheckTarget;

    public MetaCache(LuckPermsPlugin plugin, QueryOptions queryOptions, CacheMetadata metadata) {
        super(plugin, queryOptions);
        this.plugin = plugin;
        this.metadata = metadata;
        this.verboseCheckTarget = this.metadata.getHolderType() == HolderType.GROUP ? "group/" + this.metadata.getObjectName() : this.metadata.getObjectName();
    }

    @Override
    public String getMetaValue(String key, MetaCheckEvent.Origin origin) {
        String value = super.getMetaValue(key, origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.verboseCheckTarget, this.metadata.getQueryOptions(), key, String.valueOf(value));
        return value;
    }

    @Override
    public String getPrefix(MetaCheckEvent.Origin origin) {
        String value = super.getPrefix(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.verboseCheckTarget, this.metadata.getQueryOptions(), "prefix", String.valueOf(value));
        return value;
    }

    @Override
    public String getSuffix(MetaCheckEvent.Origin origin) {
        String value = super.getSuffix(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.verboseCheckTarget, this.metadata.getQueryOptions(), "suffix", String.valueOf(value));
        return value;
    }

    @Override
    public Map<String, List<String>> getMeta(MetaCheckEvent.Origin origin) {
        return new MonitoredMetaMap(super.getMeta(origin), origin);
    }

    @Override
    public int getWeight(MetaCheckEvent.Origin origin) {
        int value = super.getWeight(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.verboseCheckTarget, this.metadata.getQueryOptions(), "weight", String.valueOf(value));
        return value;
    }

    @Override
    public @Nullable String getPrimaryGroup(MetaCheckEvent.Origin origin) {
        String value = super.getPrimaryGroup(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.verboseCheckTarget, this.metadata.getQueryOptions(), "primarygroup", String.valueOf(value));
        return value;
    }

    private final class MonitoredMetaMap
    extends ForwardingMap<String, List<String>> {
        private final Map<String, List<String>> delegate;
        private final MetaCheckEvent.Origin origin;

        private MonitoredMetaMap(Map<String, List<String>> delegate, MetaCheckEvent.Origin origin) {
            this.delegate = delegate;
            this.origin = origin;
        }

        protected Map<String, List<String>> delegate() {
            return this.delegate;
        }

        public List<String> get(Object k) {
            if (k == null) {
                return null;
            }
            String key = (String)k;
            List values = (List)super.get((Object)key);
            MetaCache.this.plugin.getVerboseHandler().offerMetaCheckEvent(this.origin, MetaCache.this.verboseCheckTarget, MetaCache.this.metadata.getQueryOptions(), key, String.valueOf(values));
            return values;
        }
    }
}

