/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.metastacking.MetaStack;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.query.meta.MetaValueSelector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleMetaCache
implements CachedMetaData {
    private final LuckPermsPlugin plugin;
    private final QueryOptions queryOptions;
    protected Map<String, List<String>> meta = ImmutableMap.of();
    protected Map<String, String> flattenedMeta = ImmutableMap.of();
    protected SortedMap<Integer, String> prefixes = ImmutableSortedMap.of();
    protected SortedMap<Integer, String> suffixes = ImmutableSortedMap.of();
    protected int weight = 0;
    protected String primaryGroup = null;
    protected MetaStack prefixStack = null;
    protected MetaStack suffixStack = null;

    public SimpleMetaCache(LuckPermsPlugin plugin, QueryOptions queryOptions) {
        this.plugin = plugin;
        this.queryOptions = queryOptions;
    }

    public void loadMeta(MetaAccumulator meta) {
        this.meta = Multimaps.asMap((ListMultimap)ImmutableListMultimap.copyOf(meta.getMeta()));
        MetaValueSelector metaValueSelector = this.queryOptions.option(MetaValueSelector.KEY).orElseGet(() -> this.plugin.getConfiguration().get(ConfigKeys.META_VALUE_SELECTOR));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> e : this.meta.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            String selected = metaValueSelector.selectValue(e.getKey(), e.getValue());
            if (selected == null) {
                throw new NullPointerException(metaValueSelector + " returned null");
            }
            builder.put((Object)e.getKey(), (Object)selected);
        }
        this.flattenedMeta = builder.build();
        this.prefixes = ImmutableSortedMap.copyOfSorted(meta.getPrefixes());
        this.suffixes = ImmutableSortedMap.copyOfSorted(meta.getSuffixes());
        this.weight = meta.getWeight();
        this.primaryGroup = meta.getPrimaryGroup();
        this.prefixStack = meta.getPrefixStack();
        this.suffixStack = meta.getSuffixStack();
    }

    public String getMetaValue(String key, MetaCheckEvent.Origin origin) {
        Objects.requireNonNull(key, "key");
        return this.flattenedMeta.get(key);
    }

    @Override
    public final String getMetaValue(String key) {
        return this.getMetaValue(key, MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public String getPrefix(MetaCheckEvent.Origin origin) {
        MetaStack prefixStack = this.prefixStack;
        return prefixStack == null ? null : prefixStack.toFormattedString();
    }

    @Override
    public final String getPrefix() {
        return this.getPrefix(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public String getSuffix(MetaCheckEvent.Origin origin) {
        MetaStack suffixStack = this.suffixStack;
        return suffixStack == null ? null : suffixStack.toFormattedString();
    }

    @Override
    public final String getSuffix() {
        return this.getSuffix(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public Map<String, List<String>> getMeta(MetaCheckEvent.Origin origin) {
        return this.meta;
    }

    @Override
    public final @NonNull Map<String, List<String>> getMeta() {
        return this.getMeta(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    @Override
    public @NonNull SortedMap<Integer, String> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public @NonNull SortedMap<Integer, String> getSuffixes() {
        return this.suffixes;
    }

    public int getWeight(MetaCheckEvent.Origin origin) {
        return this.weight;
    }

    public final int getWeight() {
        return this.getWeight(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public @Nullable String getPrimaryGroup(MetaCheckEvent.Origin origin) {
        return this.primaryGroup;
    }

    @Override
    public final @Nullable String getPrimaryGroup() {
        return this.getPrimaryGroup(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    @Override
    public @NonNull MetaStackDefinition getPrefixStackDefinition() {
        return this.prefixStack.getDefinition();
    }

    @Override
    public @NonNull MetaStackDefinition getSuffixStackDefinition() {
        return this.suffixStack.getDefinition();
    }

    @Override
    public @NonNull QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

