/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.calculator.result;

import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import net.luckperms.api.util.Tristate;

public final class TristateResult {
    private static final Factory NULL_FACTORY = new Factory(null, null);
    public static final TristateResult UNDEFINED = new TristateResult(Tristate.UNDEFINED, null, null);
    private final Tristate result;
    private final Class<? extends PermissionProcessor> processorClass;
    private final String cause;

    public static TristateResult of(Tristate result) {
        return NULL_FACTORY.result(result);
    }

    private TristateResult(Tristate result, Class<? extends PermissionProcessor> processorClass, String cause) {
        this.result = result;
        this.processorClass = processorClass;
        this.cause = cause;
    }

    public Tristate result() {
        return this.result;
    }

    public Class<? extends PermissionProcessor> processorClass() {
        return this.processorClass;
    }

    public String cause() {
        return this.cause;
    }

    public String toString() {
        return "TristateResult(result=" + (Object)((Object)this.result) + ", processorClass=" + this.processorClass + ", cause=" + this.cause + ')';
    }

    public static final class Factory {
        private final Class<? extends PermissionProcessor> processorClass;
        private final TristateResult trueResult;
        private final TristateResult falseResult;

        public Factory(Class<? extends PermissionProcessor> processorClass, String defaultCause) {
            this.processorClass = processorClass;
            this.trueResult = new TristateResult(Tristate.TRUE, processorClass, defaultCause);
            this.falseResult = new TristateResult(Tristate.FALSE, processorClass, defaultCause);
        }

        public Factory(Class<? extends PermissionProcessor> processorClass) {
            this(processorClass, null);
        }

        public TristateResult result(Tristate result) {
            switch (result) {
                case TRUE: {
                    return this.trueResult;
                }
                case FALSE: {
                    return this.falseResult;
                }
                case UNDEFINED: {
                    return UNDEFINED;
                }
            }
            throw new AssertionError();
        }

        public TristateResult result(Tristate result, String cause) {
            if (result == Tristate.UNDEFINED) {
                return UNDEFINED;
            }
            return new TristateResult(result, this.processorClass, cause);
        }
    }
}

