/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.commands.group.CreateGroup;
import me.lucko.luckperms.common.commands.group.DeleteGroup;
import me.lucko.luckperms.common.commands.group.GroupParentCommand;
import me.lucko.luckperms.common.commands.group.ListGroups;
import me.lucko.luckperms.common.commands.log.LogParentCommand;
import me.lucko.luckperms.common.commands.migration.MigrationParentCommand;
import me.lucko.luckperms.common.commands.misc.ApplyEditsCommand;
import me.lucko.luckperms.common.commands.misc.BulkUpdateCommand;
import me.lucko.luckperms.common.commands.misc.CheckCommand;
import me.lucko.luckperms.common.commands.misc.EditorCommand;
import me.lucko.luckperms.common.commands.misc.ExportCommand;
import me.lucko.luckperms.common.commands.misc.ImportCommand;
import me.lucko.luckperms.common.commands.misc.InfoCommand;
import me.lucko.luckperms.common.commands.misc.NetworkSyncCommand;
import me.lucko.luckperms.common.commands.misc.ReloadConfigCommand;
import me.lucko.luckperms.common.commands.misc.SearchCommand;
import me.lucko.luckperms.common.commands.misc.SyncCommand;
import me.lucko.luckperms.common.commands.misc.TreeCommand;
import me.lucko.luckperms.common.commands.misc.VerboseCommand;
import me.lucko.luckperms.common.commands.track.CreateTrack;
import me.lucko.luckperms.common.commands.track.DeleteTrack;
import me.lucko.luckperms.common.commands.track.ListTracks;
import me.lucko.luckperms.common.commands.track.TrackParentCommand;
import me.lucko.luckperms.common.commands.user.UserParentCommand;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.AbstractLuckPermsPlugin;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;

public class CommandManager {
    private final LuckPermsPlugin plugin;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final TabCompletions tabCompletions;
    private final Map<String, Command<?>> mainCommands;

    public CommandManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        LocaleManager locale = plugin.getLocaleManager();
        this.tabCompletions = new TabCompletions(plugin);
        this.mainCommands = (Map)ImmutableList.builder().add((Object)new UserParentCommand(locale)).add((Object)new GroupParentCommand(locale)).add((Object)new TrackParentCommand(locale)).addAll(plugin.getExtraCommands()).add((Object)new LogParentCommand(locale)).add((Object)new SyncCommand(locale)).add((Object)new InfoCommand(locale)).add((Object)new EditorCommand(locale)).add((Object)new VerboseCommand(locale)).add((Object)new TreeCommand(locale)).add((Object)new SearchCommand(locale)).add((Object)new CheckCommand(locale)).add((Object)new NetworkSyncCommand(locale)).add((Object)new ImportCommand(locale)).add((Object)new ExportCommand(locale)).add((Object)new ReloadConfigCommand(locale)).add((Object)new BulkUpdateCommand(locale)).add((Object)new MigrationParentCommand(locale)).add((Object)new ApplyEditsCommand(locale)).add((Object)new CreateGroup(locale)).add((Object)new DeleteGroup(locale)).add((Object)new ListGroups(locale)).add((Object)new CreateTrack(locale)).add((Object)new DeleteTrack(locale)).add((Object)new ListTracks(locale)).build().stream().collect(ImmutableCollectors.toMap(c -> c.getName().toLowerCase(), Function.identity()));
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public TabCompletions getTabCompletions() {
        return this.tabCompletions;
    }

    public CompletableFuture<CommandResult> executeCommand(Sender sender, String label, List<String> args) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.execute(sender, label, args);
            }
            catch (Throwable e) {
                this.plugin.getLogger().severe("Exception whilst executing command: " + args.toString());
                e.printStackTrace();
                return null;
            }
        }, this.executor);
    }

    public boolean hasPermissionForAny(Sender sender) {
        return this.mainCommands.values().stream().anyMatch(c -> c.shouldDisplay() && c.isAuthorized(sender));
    }

    private CommandResult execute(Sender sender, String label, List<String> arguments) {
        CommandResult result;
        CommandManager.applyConvenienceAliases(arguments, true);
        if (arguments.isEmpty() || arguments.size() == 1 && arguments.get(0).trim().isEmpty()) {
            Message.BLANK.send(sender, "&2Running &b" + AbstractLuckPermsPlugin.getPluginName() + " v" + this.plugin.getBootstrap().getVersion() + "&2.");
            if (this.hasPermissionForAny(sender)) {
                Message.VIEW_AVAILABLE_COMMANDS_PROMPT.send(sender, label);
                return CommandResult.SUCCESS;
            }
            Collection groups = this.plugin.getGroupManager().getAll().values();
            if (groups.size() <= 1 && groups.stream().allMatch(g -> g.normalData().immutable().isEmpty())) {
                Message.FIRST_TIME_SETUP.send(sender, label, sender.getName());
            } else {
                Message.NO_PERMISSION_FOR_SUBCOMMANDS.send(sender, new Object[0]);
            }
            return CommandResult.NO_PERMISSION;
        }
        Command<?> main = this.mainCommands.get(arguments.get(0).toLowerCase());
        if (main == null) {
            this.sendCommandUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        if (!main.isAuthorized(sender)) {
            this.sendCommandUsage(sender, label);
            return CommandResult.NO_PERMISSION;
        }
        arguments.remove(0);
        if (main.getArgumentCheck().test(arguments.size())) {
            main.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        try {
            result = main.execute(this.plugin, sender, null, arguments, label);
        }
        catch (CommandException e) {
            result = e.handle(sender, label, main);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result = CommandResult.FAILURE;
        }
        return result;
    }

    public List<String> tabCompleteCommand(Sender sender, List<String> arguments) {
        CommandManager.applyConvenienceAliases(arguments, false);
        List mains = this.mainCommands.values().stream().filter(Command::shouldDisplay).filter(m -> m.isAuthorized(sender)).collect(Collectors.toList());
        return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> mains.stream().map(c -> c.getName().toLowerCase()))).from(1, partial -> mains.stream().filter(m -> m.getName().equalsIgnoreCase((String)arguments.get(0))).findFirst().map(cmd -> cmd.tabComplete(this.plugin, sender, arguments.subList(1, arguments.size()))).orElse(Collections.emptyList())).complete(arguments);
    }

    private void sendCommandUsage(Sender sender, String label) {
        Message.BLANK.send(sender, "&2Running &b" + AbstractLuckPermsPlugin.getPluginName() + " v" + this.plugin.getBootstrap().getVersion() + "&2.");
        this.mainCommands.values().stream().filter(Command::shouldDisplay).filter(c -> c.isAuthorized(sender)).forEach(c -> {
            String permission = c.getPermission().map(CommandPermission::getPermission).orElse("None");
            TextComponent component = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)TextUtils.fromLegacy("&3> &a" + String.format(c.getUsage(), label), '&').toBuilder()).applyDeep(comp -> {
                comp.hoverEvent(HoverEvent.showText((Component)TextUtils.fromLegacy(TextUtils.joinNewline("&bCommand: &2" + c.getName(), "&bDescription: &2" + c.getDescription(), "&bUsage: &2" + String.format(c.getUsage(), label), "&bPermission: &2" + permission, " ", "&7Click to auto-complete."), '&')));
                comp.clickEvent(ClickEvent.suggestCommand((String)String.format(c.getUsage(), label)));
            })).build();
            sender.sendMessage((Component)component);
        });
    }

    private static void applyConvenienceAliases(List<String> args, boolean rewriteLastArgument) {
        String arg0;
        if (args.size() >= 1 && (rewriteLastArgument || args.size() >= 2)) {
            CommandManager.replaceArgs(args, 0, arg -> {
                switch (arg) {
                    case "u": {
                        return "user";
                    }
                    case "g": {
                        return "group";
                    }
                    case "t": {
                        return "track";
                    }
                    case "i": {
                        return "info";
                    }
                }
                return null;
            });
        }
        if (args.size() >= 3 && (rewriteLastArgument || args.size() >= 4) && ((arg0 = args.get(0).toLowerCase()).equals("user") || arg0.equals("group"))) {
            String arg2;
            CommandManager.replaceArgs(args, 2, arg -> {
                switch (arg) {
                    case "p": 
                    case "perm": {
                        return "permission";
                    }
                    case "g": 
                    case "group": {
                        return "parent";
                    }
                    case "m": {
                        return "meta";
                    }
                    case "i": {
                        return "info";
                    }
                    case "e": {
                        return "editor";
                    }
                }
                return null;
            });
            if (args.size() >= 4 && (rewriteLastArgument || args.size() >= 5) && ((arg2 = args.get(2).toLowerCase()).equals("permission") || arg2.equals("parent") || arg2.equals("meta"))) {
                CommandManager.replaceArgs(args, 3, arg -> arg.equals("i") ? "info" : null);
            }
        }
    }

    private static void replaceArgs(List<String> args, int i, Function<String, String> rewrites) {
        String arg = args.get(i).toLowerCase();
        String rewrite = rewrites.apply(arg);
        if (rewrite != null) {
            args.remove(i);
            args.add(i, rewrite);
        }
    }
}

