/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.command.Argument;
import me.lucko.luckperms.common.locale.command.LocalizedCommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;

public abstract class GenericChildCommand {
    private final LocalizedCommandSpec spec;
    private final String name;
    private final CommandPermission userPermission;
    private final CommandPermission groupPermission;
    private final Predicate<? super Integer> argumentCheck;

    public GenericChildCommand(LocalizedCommandSpec spec, String name, CommandPermission userPermission, CommandPermission groupPermission, Predicate<? super Integer> argumentCheck) {
        this.spec = spec;
        this.name = name;
        this.userPermission = userPermission;
        this.groupPermission = groupPermission;
        this.argumentCheck = argumentCheck;
    }

    public abstract CommandResult execute(LuckPermsPlugin var1, Sender var2, PermissionHolder var3, List<String> var4, String var5, CommandPermission var6) throws CommandException;

    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return Collections.emptyList();
    }

    public LocalizedCommandSpec getSpec() {
        return this.spec;
    }

    public String getName() {
        return this.name;
    }

    public CommandPermission getUserPermission() {
        return this.userPermission;
    }

    public CommandPermission getGroupPermission() {
        return this.groupPermission;
    }

    public Predicate<? super Integer> getArgumentCheck() {
        return this.argumentCheck;
    }

    public void sendUsage(Sender sender) {
        StringBuilder sb = new StringBuilder();
        if (this.getArgs() != null) {
            sb.append(Message.COMMAND_USAGE_ARGUMENT_JOIN.asString(sender.getPlugin().getLocaleManager(), new Object[0]));
            for (Argument arg : this.getArgs()) {
                sb.append(arg.asPrettyString(sender.getPlugin().getLocaleManager())).append(" ");
            }
        }
        Message.COMMAND_USAGE_BRIEF.send(sender, this.getName(), sb.toString());
    }

    public void sendDetailedUsage(Sender sender) {
        Message.COMMAND_USAGE_DETAILED_HEADER.send(sender, this.getName(), this.getDescription());
        if (this.getArgs() != null) {
            Message.COMMAND_USAGE_DETAILED_ARGS_HEADER.send(sender, new Object[0]);
            for (Argument arg : this.getArgs()) {
                Message.COMMAND_USAGE_DETAILED_ARG.send(sender, arg.asPrettyString(sender.getPlugin().getLocaleManager()), arg.getDescription());
            }
        }
    }

    public boolean isAuthorized(Sender sender, HolderType type) {
        switch (type) {
            case USER: {
                return this.userPermission.isAuthorized(sender);
            }
            case GROUP: {
                return this.groupPermission.isAuthorized(sender);
            }
        }
        throw new AssertionError((Object)type);
    }

    public String getDescription() {
        return this.spec.description();
    }

    public List<Argument> getArgs() {
        return this.spec.args();
    }
}

