/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.locale.command.LocalizedCommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ParentCommand<T, I>
extends Command<Void> {
    private final List<Command<T>> children;
    private final Type type;

    public ParentCommand(LocalizedCommandSpec spec, String name, Type type, List<Command<T>> children) {
        super(spec, name, null, Predicates.alwaysFalse());
        this.children = children;
        this.type = type;
    }

    public @NonNull List<Command<T>> getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Void ignored, List<String> args, String label) {
        if (args.size() < this.type.minArgs) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        Command sub = this.getChildren().stream().filter(s -> s.getName().equalsIgnoreCase((String)args.get(this.type.cmdIndex))).findFirst().orElse(null);
        if (sub == null) {
            Message.COMMAND_NOT_RECOGNISED.send(sender, new Object[0]);
            return CommandResult.INVALID_ARGS;
        }
        if (!sub.isAuthorized(sender)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        if (sub.getArgumentCheck().test(args.size() - this.type.minArgs)) {
            sub.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String targetArgument = args.get(0);
        I targetId = null;
        if (this.type == Type.TAKES_ARGUMENT_FOR_TARGET && (targetId = (I)this.parseTarget(targetArgument, plugin, sender)) == null) {
            return CommandResult.LOADING_ERROR;
        }
        ReentrantLock lock = this.getLockForTarget(targetId);
        lock.lock();
        try {
            CommandResult result;
            T target = this.getTarget(targetId, plugin, sender);
            if (target == null) {
                CommandResult commandResult = CommandResult.LOADING_ERROR;
                return commandResult;
            }
            try {
                result = sub.execute(plugin, sender, target, args.subList(this.type.minArgs, args.size()), label);
            }
            catch (CommandException e) {
                result = e.handle(sender, label, sub);
            }
            this.cleanup(target, plugin);
            CommandResult commandResult = result;
            return commandResult;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        switch (this.type) {
            case TAKES_ARGUMENT_FOR_TARGET: {
                return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> this.getTargets(plugin).stream())).at(1, CompletionSupplier.startsWith(() -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).map(s -> s.getName().toLowerCase()))).from(2, partial -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).filter(s -> s.getName().equalsIgnoreCase((String)args.get(1))).findFirst().map(cmd -> cmd.tabComplete(plugin, sender, args.subList(2, args.size()))).orElse(Collections.emptyList())).complete(args);
            }
            case NO_TARGET_ARGUMENT: {
                return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).map(s -> s.getName().toLowerCase()))).from(1, partial -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).filter(s -> s.getName().equalsIgnoreCase((String)args.get(0))).findFirst().map(cmd -> cmd.tabComplete(plugin, sender, args.subList(1, args.size()))).orElse(Collections.emptyList())).complete(args);
            }
        }
        throw new AssertionError((Object)this.type);
    }

    @Override
    public void sendUsage(Sender sender, String label) {
        List subs = this.getChildren().stream().filter(s -> s.isAuthorized(sender)).collect(Collectors.toList());
        if (!subs.isEmpty()) {
            Message.MAIN_COMMAND_USAGE_HEADER.send(sender, this.getName(), String.format(this.getUsage(), label));
            for (Command s2 : subs) {
                s2.sendUsage(sender, label);
            }
        } else {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
        }
    }

    @Override
    public void sendDetailedUsage(Sender sender, String label) {
        this.sendUsage(sender, label);
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return this.getChildren().stream().anyMatch(sc -> sc.isAuthorized(sender));
    }

    protected abstract List<String> getTargets(LuckPermsPlugin var1);

    protected abstract I parseTarget(String var1, LuckPermsPlugin var2, Sender var3);

    protected abstract ReentrantLock getLockForTarget(I var1);

    protected abstract T getTarget(I var1, LuckPermsPlugin var2, Sender var3);

    protected abstract void cleanup(T var1, LuckPermsPlugin var2);

    public static enum Type {
        NO_TARGET_ARGUMENT(0),
        TAKES_ARGUMENT_FOR_TARGET(1);

        private final int cmdIndex;
        private final int minArgs;

        private Type(int cmdIndex) {
            this.cmdIndex = cmdIndex;
            this.minArgs = cmdIndex + 1;
        }
    }
}

