/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.tabcomplete;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.treeview.PermissionRegistry;
import me.lucko.luckperms.common.treeview.TreeNode;
import net.luckperms.api.context.ImmutableContextSet;

public final class TabCompletions {
    private static final CompletionSupplier BOOLEAN = CompletionSupplier.startsWith("true", "false");
    private final CompletionSupplier groups = CompletionSupplier.startsWith(() -> plugin.getGroupManager().getAll().keySet().stream());
    private final CompletionSupplier tracks = CompletionSupplier.startsWith(() -> plugin.getTrackManager().getAll().keySet().stream());
    private final CompletionSupplier permissions = partial -> {
        PermissionRegistry cache = plugin.getPermissionRegistry();
        String start = partial.toLowerCase();
        ArrayList parts = new ArrayList(Splitter.on((char)'.').splitToList((CharSequence)start));
        TreeNode root = cache.getRootNode();
        if (parts.size() <= 1) {
            if (!root.getChildren().isPresent()) {
                return Collections.emptyList();
            }
            return CompletionSupplier.startsWith(root.getChildren().get().keySet()).supplyCompletions(start);
        }
        String incomplete = (String)parts.remove(parts.size() - 1);
        for (String s2 : parts) {
            if (!root.getChildren().isPresent()) {
                return Collections.emptyList();
            }
            TreeNode n = root.getChildren().get().get(s2);
            if (n == null) {
                return Collections.emptyList();
            }
            root = n;
        }
        if (!root.getChildren().isPresent()) {
            return Collections.emptyList();
        }
        return root.getChildren().get().keySet().stream().filter(TabCompleter.startsWithIgnoreCase(incomplete)).map(s -> String.join((CharSequence)".", parts) + "." + s).collect(Collectors.toList());
    };
    private final CompletionSupplier contexts = partial -> {
        ImmutableContextSet potentialContexts = plugin.getContextManager().getPotentialContexts();
        int index = partial.indexOf(61);
        if (index == -1) {
            return CompletionSupplier.startsWith(potentialContexts.toMap().keySet()).supplyCompletions(partial);
        }
        String key = partial.substring(0, index);
        if (key.equals("") || key.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String value = partial.substring(index + 1).trim();
        Set<String> potentialValues = potentialContexts.getValues(key);
        return potentialValues.stream().filter(TabCompleter.startsWithIgnoreCase(value)).map(s -> key + "=" + s).collect(Collectors.toList());
    };

    public TabCompletions(LuckPermsPlugin plugin) {
    }

    public static CompletionSupplier booleans() {
        return BOOLEAN;
    }

    public static CompletionSupplier groups(LuckPermsPlugin plugin) {
        return plugin.getCommandManager().getTabCompletions().groups;
    }

    public static CompletionSupplier tracks(LuckPermsPlugin plugin) {
        return plugin.getCommandManager().getTabCompletions().tracks;
    }

    public static CompletionSupplier permissions(LuckPermsPlugin plugin) {
        return plugin.getCommandManager().getTabCompletions().permissions;
    }

    public static CompletionSupplier contexts(LuckPermsPlugin plugin) {
        return plugin.getCommandManager().getTabCompletions().contexts;
    }
}

