/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.node.factory.NodeCommandFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.ComponentBuilder;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;

public class MetaInfo
extends GenericChildCommand {
    private static String processLocation(Node node, PermissionHolder holder) {
        String location = node.metadata(InheritanceOriginMetadata.KEY).getOrigin().getName();
        return location.equalsIgnoreCase(holder.getObjectName()) ? "self" : location;
    }

    public MetaInfo(LocaleManager locale) {
        super(CommandSpec.META_INFO.localize(locale), "info", CommandPermission.USER_META_INFO, CommandPermission.GROUP_META_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        TreeSet prefixes = new TreeSet(MetaComparator.INSTANCE.reversed());
        TreeSet suffixes = new TreeSet(MetaComparator.INSTANCE.reversed());
        LinkedHashSet<MetaNode> meta = new LinkedHashSet<MetaNode>();
        for (Node node : holder.resolveInheritedNodes(QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL)) {
            if (!NodeType.META_OR_CHAT_META.matches(node)) continue;
            if (node instanceof PrefixNode) {
                PrefixNode pn = (PrefixNode)node;
                prefixes.add(Maps.immutableEntry((Object)pn.getPriority(), (Object)pn));
                continue;
            }
            if (node instanceof SuffixNode) {
                SuffixNode sn = (SuffixNode)node;
                suffixes.add(Maps.immutableEntry((Object)sn.getPriority(), (Object)sn));
                continue;
            }
            if (!(node instanceof MetaNode)) continue;
            meta.add((MetaNode)node);
        }
        if (prefixes.isEmpty()) {
            Message.CHAT_META_PREFIX_NONE.send(sender, holder.getFormattedDisplayName());
        } else {
            Message.CHAT_META_PREFIX_HEADER.send(sender, holder.getFormattedDisplayName());
            MetaInfo.sendChatMetaMessage(prefixes, sender, holder, label);
        }
        if (suffixes.isEmpty()) {
            Message.CHAT_META_SUFFIX_NONE.send(sender, holder.getFormattedDisplayName());
        } else {
            Message.CHAT_META_SUFFIX_HEADER.send(sender, holder.getFormattedDisplayName());
            MetaInfo.sendChatMetaMessage(suffixes, sender, holder, label);
        }
        if (meta.isEmpty()) {
            Message.META_NONE.send(sender, holder.getFormattedDisplayName());
        } else {
            Message.META_HEADER.send(sender, holder.getFormattedDisplayName());
            MetaInfo.sendMetaMessage(meta, sender, holder, label);
        }
        return CommandResult.SUCCESS;
    }

    private static void sendMetaMessage(Set<MetaNode> meta, Sender sender, PermissionHolder holder, String label) {
        for (MetaNode m : meta) {
            String location = MetaInfo.processLocation(m, holder);
            if (!m.getContexts().isEmpty()) {
                String context = MessageUtils.getAppendableNodeContextString(sender.getPlugin().getLocaleManager(), m);
                TextComponent.Builder builder = (TextComponent.Builder)Message.META_ENTRY_WITH_CONTEXT.asComponent(sender.getPlugin().getLocaleManager(), m.getMetaKey(), m.getMetaValue(), location, context).toBuilder();
                builder.applyDeep(MetaInfo.makeFancy(holder, label, m));
                sender.sendMessage((Component)builder.build());
                continue;
            }
            TextComponent.Builder builder = (TextComponent.Builder)Message.META_ENTRY.asComponent(sender.getPlugin().getLocaleManager(), m.getMetaKey(), m.getMetaValue(), location).toBuilder();
            builder.applyDeep(MetaInfo.makeFancy(holder, label, m));
            sender.sendMessage((Component)builder.build());
        }
    }

    private static void sendChatMetaMessage(SortedSet<? extends Map.Entry<Integer, ? extends ChatMetaNode<?, ?>>> meta, Sender sender, PermissionHolder holder, String label) {
        for (Map.Entry entry : meta) {
            String location = MetaInfo.processLocation((Node)entry.getValue(), holder);
            if (!((ChatMetaNode)entry.getValue()).getContexts().isEmpty()) {
                String context = MessageUtils.getAppendableNodeContextString(sender.getPlugin().getLocaleManager(), (Node)entry.getValue());
                TextComponent.Builder builder = (TextComponent.Builder)Message.CHAT_META_ENTRY_WITH_CONTEXT.asComponent(sender.getPlugin().getLocaleManager(), entry.getKey(), ((ChatMetaNode)entry.getValue()).getMetaValue(), location, context).toBuilder();
                builder.applyDeep(MetaInfo.makeFancy(holder, label, (ChatMetaNode)entry.getValue()));
                sender.sendMessage((Component)builder.build());
                continue;
            }
            TextComponent.Builder builder = (TextComponent.Builder)Message.CHAT_META_ENTRY.asComponent(sender.getPlugin().getLocaleManager(), entry.getKey(), ((ChatMetaNode)entry.getValue()).getMetaValue(), location).toBuilder();
            builder.applyDeep(MetaInfo.makeFancy(holder, label, (ChatMetaNode)entry.getValue()));
            sender.sendMessage((Component)builder.build());
        }
    }

    private static Consumer<ComponentBuilder<?, ?>> makeFancy(PermissionHolder holder, String label, ChatMetaNode<?, ?> node) {
        Group group;
        String location = node.metadata(InheritanceOriginMetadata.KEY).getOrigin().getName();
        if (!location.equals(holder.getObjectName()) && (group = (Group)holder.getPlugin().getGroupManager().getIfLoaded(location)) != null) {
            holder = group;
        }
        HoverEvent hoverEvent = HoverEvent.showText((Component)TextUtils.fromLegacy(TextUtils.joinNewline("\u00a53> \u00a5a" + node.getPriority() + " \u00a57- \u00a5r" + node.getMetaValue(), " ", "\u00a57Click to remove this " + node.getMetaType().name().toLowerCase() + " from " + holder.getPlainDisplayName()), '\u00a5'));
        String id = holder.getType() == HolderType.GROUP ? holder.getObjectName() : holder.getFormattedDisplayName();
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        String command = "/" + label + " " + NodeCommandFactory.generateCommand(node, id, holder.getType(), false, explicitGlobalContext);
        ClickEvent clickEvent = ClickEvent.suggestCommand((String)command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }

    private static Consumer<ComponentBuilder<?, ?>> makeFancy(PermissionHolder holder, String label, MetaNode node) {
        Group group;
        String location = node.metadata(InheritanceOriginMetadata.KEY).getOrigin().getName();
        if (!location.equals(holder.getObjectName()) && (group = (Group)holder.getPlugin().getGroupManager().getIfLoaded(location)) != null) {
            holder = group;
        }
        HoverEvent hoverEvent = HoverEvent.showText((Component)TextUtils.fromLegacy(TextUtils.joinNewline("\u00a53> \u00a5r" + node.getMetaKey() + " \u00a57- \u00a5r" + node.getMetaValue(), " ", "\u00a57Click to remove this meta pair from " + holder.getPlainDisplayName()), '\u00a5'));
        String id = holder.getType() == HolderType.GROUP ? holder.getObjectName() : holder.getPlainDisplayName();
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        String command = "/" + label + " " + NodeCommandFactory.generateCommand(node, id, holder.getType(), false, explicitGlobalContext);
        ClickEvent clickEvent = ClickEvent.suggestCommand((String)command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }

    private static final class MetaComparator
    implements Comparator<Map.Entry<Integer, ? extends ChatMetaNode<?, ?>>> {
        public static final MetaComparator INSTANCE = new MetaComparator();

        private MetaComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, ? extends ChatMetaNode<?, ?>> o1, Map.Entry<Integer, ? extends ChatMetaNode<?, ?>> o2) {
            int result = Integer.compare(o1.getKey(), o2.getKey());
            if (result != 0) {
                return result;
            }
            return NodeWithContextComparator.normal().compare(o1.getValue(), o2.getValue());
        }
    }
}

