/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import java.util.List;
import java.util.OptionalInt;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;

public class MetaSetChatMeta
extends GenericChildCommand {
    private final ChatMetaType type;

    public MetaSetChatMeta(LocaleManager locale, ChatMetaType type) {
        super(type == ChatMetaType.PREFIX ? CommandSpec.META_SETPREFIX.localize(locale) : CommandSpec.META_SETSUFFIX.localize(locale), "set" + type.name().toLowerCase(), type == ChatMetaType.PREFIX ? CommandPermission.USER_META_SET_PREFIX : CommandPermission.USER_META_SET_SUFFIX, type == ChatMetaType.PREFIX ? CommandPermission.GROUP_META_SET_PREFIX : CommandPermission.GROUP_META_SET_SUFFIX, Predicates.is(0));
        this.type = type;
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) throws CommandException {
        DataMutateResult result;
        MutableContextSet context;
        String meta;
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        int priority = ArgumentParser.parseIntOrElse(0, args, Integer.MIN_VALUE);
        if (priority == Integer.MIN_VALUE) {
            meta = ArgumentParser.parseString(0, args);
            context = ArgumentParser.parseContext(1, args, plugin);
        } else {
            if (args.size() <= 1) {
                this.sendDetailedUsage(sender);
                return CommandResult.INVALID_ARGS;
            }
            meta = ArgumentParser.parseString(1, args);
            context = ArgumentParser.parseContext(2, args, plugin);
        }
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        holder.removeIf(DataType.NORMAL, context, this.type.nodeType()::matches, false);
        if (priority == Integer.MIN_VALUE) {
            OptionalInt weight;
            MetaAccumulator metaAccumulator = holder.accumulateMeta(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(context).build());
            priority = metaAccumulator.getChatMeta(this.type).keySet().stream().mapToInt(e -> e).max().orElse(0) + 1;
            if (holder instanceof Group && (weight = holder.getWeight()).isPresent() && weight.getAsInt() > priority) {
                priority = weight.getAsInt();
            }
        }
        if ((result = holder.setNode(DataType.NORMAL, (Node)((ChatMetaNode.Builder)this.type.builder(meta, priority).withContext(context)).build(), true)).wasSuccessful()) {
            TextComponent.Builder builder = (TextComponent.Builder)Message.ADD_CHATMETA_SUCCESS.asComponent(plugin.getLocaleManager(), holder.getFormattedDisplayName(), this.type.name().toLowerCase(), meta, priority, MessageUtils.contextSetToString(plugin.getLocaleManager(), context)).toBuilder();
            HoverEvent event = HoverEvent.showText((Component)TextUtils.fromLegacy("\u00a53Raw " + this.type.name().toLowerCase() + ": \u00a5r" + meta, '\u00a5'));
            builder.applyDeep(c -> c.hoverEvent(event));
            sender.sendMessage((Component)builder.build());
            LoggedAction.build().source(sender).target(holder).description("meta", "set" + this.type.name().toLowerCase(), priority, meta, context).build().submit(plugin, sender);
            StorageAssistant.save(holder, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.ALREADY_HAS_CHAT_META.send(sender, holder.getFormattedDisplayName(), this.type.name().toLowerCase(), meta, priority, MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
        return CommandResult.STATE_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().from(1, TabCompletions.contexts(plugin)).complete(args);
    }
}

