/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.other;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataType;

public class HolderClear<T extends PermissionHolder>
extends ChildCommand<T> {
    public HolderClear(LocaleManager locale, HolderType type) {
        super(CommandSpec.HOLDER_CLEAR.localize(locale), "clear", type == HolderType.USER ? CommandPermission.USER_CLEAR : CommandPermission.GROUP_CLEAR, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, T holder, List<String> args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        int before = ((PermissionHolder)holder).normalData().immutable().size();
        MutableContextSet context = ArgumentParser.parseContext(0, args, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, this.getPermission().get(), context) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        if (context.isEmpty()) {
            ((PermissionHolder)holder).clearNodes(DataType.NORMAL, null, true);
        } else {
            ((PermissionHolder)holder).clearNodes(DataType.NORMAL, context, true);
        }
        int changed = before - ((PermissionHolder)holder).normalData().immutable().size();
        if (changed == 1) {
            Message.CLEAR_SUCCESS_SINGULAR.send(sender, ((PermissionHolder)holder).getFormattedDisplayName(), MessageUtils.contextSetToString(plugin.getLocaleManager(), context), changed);
        } else {
            Message.CLEAR_SUCCESS.send(sender, ((PermissionHolder)holder).getFormattedDisplayName(), MessageUtils.contextSetToString(plugin.getLocaleManager(), context), changed);
        }
        LoggedAction.build().source(sender).target((PermissionHolder)holder).description("clear", context).build().submit(plugin, sender);
        StorageAssistant.save(holder, sender, plugin);
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().from(0, TabCompletions.contexts(plugin)).complete(args);
    }
}

