/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.permission;

import java.util.List;
import java.util.Optional;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;
import net.luckperms.api.util.Tristate;

public class PermissionCheckInherits
extends GenericChildCommand {
    public PermissionCheckInherits(LocaleManager locale) {
        super(CommandSpec.PERMISSION_CHECK_INHERITS.localize(locale), "checkinherits", CommandPermission.USER_PERM_CHECK_INHERITS, CommandPermission.GROUP_PERM_CHECK_INHERITS, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        String node = ArgumentParser.parseString(0, args);
        MutableContextSet context = ArgumentParser.parseContext(1, args, plugin);
        Optional<Node> match = holder.resolveInheritedNodes(QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL).stream().filter(n -> n.getKey().equalsIgnoreCase(node) && n.getContexts().equals(context)).findFirst();
        String location = match.map(n -> n.metadata(InheritanceOriginMetadata.KEY).getOrigin().getName()).orElse(null);
        if (location == null || location.equalsIgnoreCase(holder.getObjectName())) {
            location = "self";
        }
        String s = MessageUtils.formatTristate(match.map(n -> Tristate.of(n.getValue())).orElse(Tristate.UNDEFINED));
        Message.CHECK_INHERITS_PERMISSION.send(sender, holder.getFormattedDisplayName(), node, s, MessageUtils.contextSetToString(plugin.getLocaleManager(), context), location);
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.permissions(plugin)).from(1, TabCompletions.contexts(plugin)).complete(args);
    }
}

