/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.SortMode;
import me.lucko.luckperms.common.command.utils.SortType;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.node.factory.NodeCommandFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.ComponentBuilder;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;

public class PermissionInfo
extends GenericChildCommand {
    private static final Comparator<Node> ALPHABETICAL_NODE_COMPARATOR = (o1, o2) -> {
        int i = o1.getKey().compareTo(o2.getKey());
        if (i != 0) {
            return i;
        }
        return NodeWithContextComparator.reverse().compare((Node)o1, (Node)o2);
    };

    public PermissionInfo(LocaleManager locale) {
        super(CommandSpec.PERMISSION_INFO.localize(locale), "info", CommandPermission.USER_PERM_INFO, CommandPermission.GROUP_PERM_INFO, Predicates.notInRange(0, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        int page = ArgumentParser.parseIntOrElse(0, args, 1);
        SortMode sortMode = SortMode.determine(args);
        ArrayList<Node> nodes = new ArrayList<Node>(holder.normalData().asSortedSet());
        nodes.removeIf(NodeType.INHERITANCE.predicate(n -> n.getValue() && plugin.getGroupManager().isLoaded(n.getGroupName())).or(NodeType.META_OR_CHAT_META.predicate()));
        if (nodes.isEmpty()) {
            Message.PERMISSION_INFO_NO_DATA.send(sender, holder.getFormattedDisplayName());
            return CommandResult.SUCCESS;
        }
        if (sortMode.getType() == SortType.ALPHABETICALLY) {
            nodes.sort(ALPHABETICAL_NODE_COMPARATOR);
        }
        if (!sortMode.isAscending()) {
            Collections.reverse(nodes);
        }
        int pageIndex = page - 1;
        List<List<Node>> pages = Iterators.divideIterable(nodes, 19);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List<Node> content = pages.get(pageIndex);
        Message.PERMISSION_INFO.send(sender, holder.getFormattedDisplayName(), page, pages.size(), nodes.size());
        for (Node node : content) {
            String s = "&3> " + (node.getValue() ? "&a" : "&c") + node.getKey() + (sender.isConsole() ? " &7(" + node.getValue() + "&7)" : "") + MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node);
            if (node.hasExpiry()) {
                s = s + "\n&2-    expires in " + DurationFormatter.LONG.format(node.getExpiryDuration());
            }
            TextComponent message = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)TextUtils.fromLegacy(s, '&').toBuilder()).applyDeep(PermissionInfo.makeFancy(holder, label, node))).build();
            sender.sendMessage((Component)message);
        }
        return CommandResult.SUCCESS;
    }

    private static Consumer<ComponentBuilder<?, ?>> makeFancy(PermissionHolder holder, String label, Node node) {
        HoverEvent hoverEvent = HoverEvent.showText((Component)TextUtils.fromLegacy(TextUtils.joinNewline("\u00a53> " + (node.getValue() ? "\u00a5a" : "\u00a5c") + node.getKey(), " ", "\u00a57Click to remove this node from " + holder.getPlainDisplayName()), '\u00a5'));
        String id = holder.getType() == HolderType.GROUP ? holder.getObjectName() : holder.getPlainDisplayName();
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        String command = "/" + label + " " + NodeCommandFactory.generateCommand(node, id, holder.getType(), false, explicitGlobalContext);
        ClickEvent clickEvent = ClickEvent.suggestCommand((String)command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }
}

