/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.event.cause.CreationCause;

public class CreateGroup
extends SingleCommand {
    public CreateGroup(LocaleManager locale) {
        super(CommandSpec.CREATE_GROUP.localize(locale), "CreateGroup", CommandPermission.CREATE_GROUP, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String groupName = args.get(0).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(groupName)) {
            Message.GROUP_INVALID_ENTRY.send(sender, groupName);
            return CommandResult.INVALID_ARGS;
        }
        if (plugin.getStorage().loadGroup(groupName).join().isPresent()) {
            Message.ALREADY_EXISTS.send(sender, groupName);
            return CommandResult.INVALID_ARGS;
        }
        try {
            plugin.getStorage().createAndLoadGroup(groupName, CreationCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.CREATE_ERROR.send(sender, groupName);
            return CommandResult.FAILURE;
        }
        Message.CREATE_SUCCESS.send(sender, groupName);
        LoggedAction.build().source(sender).targetName(groupName).targetType(Action.Target.Type.GROUP).description("create").build().submit(plugin, sender);
        return CommandResult.SUCCESS;
    }
}

