/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.event.cause.DeletionCause;

public class DeleteGroup
extends SingleCommand {
    public DeleteGroup(LocaleManager locale) {
        super(CommandSpec.DELETE_GROUP.localize(locale), "DeleteGroup", CommandPermission.DELETE_GROUP, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String groupName = args.get(0).toLowerCase();
        if (groupName.equalsIgnoreCase("default")) {
            Message.DELETE_GROUP_ERROR_DEFAULT.send(sender, new Object[0]);
            return CommandResult.INVALID_ARGS;
        }
        Group group = plugin.getStorage().loadGroup(groupName).join().orElse(null);
        if (group == null) {
            Message.GROUP_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        try {
            plugin.getStorage().deleteGroup(group, DeletionCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.DELETE_ERROR.send(sender, group.getFormattedDisplayName());
            return CommandResult.FAILURE;
        }
        Message.DELETE_SUCCESS.send(sender, group.getFormattedDisplayName());
        LoggedAction.build().source(sender).targetName(groupName).targetType(Action.Target.Type.GROUP).description("delete").build().submit(plugin, sender);
        plugin.getSyncTaskBuffer().request();
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).complete(args);
    }
}

