/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.cacheddata.type.MetaCache;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;

public class GroupInfo
extends ChildCommand<Group> {
    public GroupInfo(LocaleManager locale) {
        super(CommandSpec.GROUP_INFO.localize(locale), "info", CommandPermission.GROUP_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Group group, List<String> args, String label) {
        Map<String, List<String>> metaMap;
        String sussexValue;
        MetaCache data;
        String prefixValue;
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), group)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Message.GROUP_INFO_GENERAL.send(sender, group.getName(), group.getPlainDisplayName(), group.getWeight().isPresent() ? Integer.valueOf(group.getWeight().getAsInt()) : "None");
        List parents = group.normalData().inheritanceAsSortedSet().stream().filter(Node::getValue).filter(n -> !n.hasExpiry()).collect(Collectors.toList());
        List tempParents = group.normalData().inheritanceAsSortedSet().stream().filter(Node::getValue).filter(Node::hasExpiry).collect(Collectors.toList());
        if (!parents.isEmpty()) {
            Message.INFO_PARENT_HEADER.send(sender, new Object[0]);
            for (InheritanceNode node : parents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
            }
        }
        if (!tempParents.isEmpty()) {
            Message.INFO_TEMP_PARENT_HEADER.send(sender, new Object[0]);
            for (InheritanceNode node : tempParents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
                Message.INFO_PARENT_ENTRY_EXPIRY.send(sender, DurationFormatter.LONG.format(node.getExpiryDuration()));
            }
        }
        QueryOptions queryOptions = plugin.getContextManager().getStaticQueryOptions();
        String context = "&bNone";
        String prefix = "&bNone";
        String suffix = "&bNone";
        String meta = "&bNone";
        ImmutableContextSet contextSet = queryOptions.context();
        if (!contextSet.isEmpty()) {
            context = contextSet.toSet().stream().map(e -> MessageUtils.contextToString(plugin.getLocaleManager(), e.getKey(), e.getValue())).collect(Collectors.joining(" "));
        }
        if ((prefixValue = (data = group.getCachedData().getMetaData(queryOptions)).getPrefix(MetaCheckEvent.Origin.INTERNAL)) != null) {
            prefix = "&f\"" + prefixValue + "&f\"";
        }
        if ((sussexValue = data.getSuffix(MetaCheckEvent.Origin.INTERNAL)) != null) {
            suffix = "&f\"" + sussexValue + "&f\"";
        }
        if (!(metaMap = data.getMeta(MetaCheckEvent.Origin.INTERNAL)).isEmpty()) {
            meta = metaMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> Maps.immutableEntry(entry.getKey(), (Object)value))).map(e -> MessageUtils.contextToString(plugin.getLocaleManager(), (String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(" "));
        }
        Message.GROUP_INFO_CONTEXTUAL_DATA.send(sender, context, prefix, suffix, meta);
        return CommandResult.SUCCESS;
    }
}

