/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.comparator.NodeEntryComparator;
import me.lucko.luckperms.common.node.factory.NodeCommandFactory;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.ComponentBuilder;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public class GroupListMembers
extends ChildCommand<Group> {
    public GroupListMembers(LocaleManager locale) {
        super(CommandSpec.GROUP_LISTMEMBERS.localize(locale), "listmembers", CommandPermission.GROUP_LIST_MEMBERS, Predicates.notInRange(0, 1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Group group, List<String> args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), group)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Inheritance node = Inheritance.builder(group.getName()).build();
        ConstraintNodeMatcher<Inheritance> matcher = StandardNodeMatchers.key(node);
        int page = ArgumentParser.parseIntOrElse(0, args, 1);
        Message.SEARCH_SEARCHING_MEMBERS.send(sender, group.getName());
        List matchedUsers = plugin.getStorage().getUsersWithPermission(matcher).join().stream().filter(n -> ((InheritanceNode)n.getNode()).getValue()).collect(Collectors.toList());
        if (group.getName().equals("default")) {
            for (User user : plugin.getUserManager().getAll().values()) {
                if (plugin.getUserManager().shouldSave(user)) continue;
                matchedUsers.add(NodeEntry.of(user.getUniqueId(), node));
            }
            Message.SEARCH_RESULT_GROUP_DEFAULT.send(sender, new Object[0]);
        }
        List matchedGroups = plugin.getStorage().getGroupsWithPermission(matcher).join().stream().filter(n -> ((InheritanceNode)n.getNode()).getValue()).collect(Collectors.toList());
        int users = matchedUsers.size();
        int groups = matchedGroups.size();
        Message.SEARCH_RESULT.send(sender, users + groups, users, groups);
        if (!matchedUsers.isEmpty()) {
            LoadingMap<UUID, String> uuidLookups = LoadingMap.of(u -> {
                String s = plugin.getStorage().getPlayerName((UUID)u).join();
                if (s != null && !s.isEmpty() && !s.equals("null")) {
                    return s;
                }
                if (plugin.getConfiguration().get(ConfigKeys.USE_SERVER_UUID_CACHE).booleanValue() && (s = (String)plugin.getBootstrap().lookupUsername((UUID)u).orElse(null)) != null) {
                    return s;
                }
                return u.toString();
            });
            GroupListMembers.sendResult(sender, matchedUsers, uuidLookups::get, Message.SEARCH_SHOWING_USERS, HolderType.USER, label, page);
        }
        if (!matchedGroups.isEmpty()) {
            GroupListMembers.sendResult(sender, matchedGroups, Function.identity(), Message.SEARCH_SHOWING_GROUPS, HolderType.GROUP, label, page);
        }
        return CommandResult.SUCCESS;
    }

    private static <T extends Comparable<T>> void sendResult(Sender sender, List<NodeEntry<T, InheritanceNode>> results, Function<T, String> lookupFunction, Message headerMessage, HolderType holderType, String label, int page) {
        results = new ArrayList<NodeEntry<T, InheritanceNode>>(results);
        results.sort(NodeEntryComparator.normal());
        int pageIndex = page - 1;
        List<List<NodeEntry<T, InheritanceNode>>> pages = Iterators.divideIterable(results, 15);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List<NodeEntry<T, InheritanceNode>> content = pages.get(pageIndex);
        List mappedContent = content.stream().map(hp -> Maps.immutableEntry(lookupFunction.apply(hp.getHolder()), (Object)hp)).collect(Collectors.toList());
        headerMessage.send(sender, page, pages.size(), results.size());
        for (Map.Entry ent : mappedContent) {
            String s = "&3> &b" + (String)ent.getKey() + " " + GroupListMembers.getNodeExpiryString(((NodeEntry)ent.getValue()).getNode()) + MessageUtils.getAppendableNodeContextString(sender.getPlugin().getLocaleManager(), ((NodeEntry)ent.getValue()).getNode());
            TextComponent message = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)TextUtils.fromLegacy(s, '&').toBuilder()).applyDeep(GroupListMembers.makeFancy((String)ent.getKey(), holderType, label, (NodeEntry)ent.getValue(), sender.getPlugin()))).build();
            sender.sendMessage((Component)message);
        }
    }

    private static String getNodeExpiryString(Node node) {
        if (!node.hasExpiry()) {
            return "";
        }
        return " &8(&7expires in " + DurationFormatter.LONG.format(node.getExpiryDuration()) + "&8)";
    }

    private static Consumer<ComponentBuilder<?, ?>> makeFancy(String holderName, HolderType holderType, String label, NodeEntry<?, ?> perm, LuckPermsPlugin plugin) {
        HoverEvent hoverEvent = HoverEvent.showText((Component)TextUtils.fromLegacy(TextUtils.joinNewline("&3> &b" + ((InheritanceNode)perm.getNode()).getGroupName(), " ", "&7Click to remove this parent from " + holderName), '&'));
        boolean explicitGlobalContext = !plugin.getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        String command = "/" + label + " " + NodeCommandFactory.generateCommand(perm.getNode(), holderName, holderType, false, explicitGlobalContext);
        ClickEvent clickEvent = ClickEvent.suggestCommand((String)command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }
}

