/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.common.command.abstraction.ParentCommand;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.commands.generic.meta.CommandMeta;
import me.lucko.luckperms.common.commands.generic.other.HolderClear;
import me.lucko.luckperms.common.commands.generic.other.HolderEditor;
import me.lucko.luckperms.common.commands.generic.other.HolderShowTracks;
import me.lucko.luckperms.common.commands.generic.parent.CommandParent;
import me.lucko.luckperms.common.commands.generic.permission.CommandPermission;
import me.lucko.luckperms.common.commands.group.GroupClone;
import me.lucko.luckperms.common.commands.group.GroupInfo;
import me.lucko.luckperms.common.commands.group.GroupListMembers;
import me.lucko.luckperms.common.commands.group.GroupRename;
import me.lucko.luckperms.common.commands.group.GroupSetDisplayName;
import me.lucko.luckperms.common.commands.group.GroupSetWeight;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;

public class GroupParentCommand
extends ParentCommand<Group, String> {
    private final LoadingCache<String, ReentrantLock> locks = CaffeineFactory.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(key -> new ReentrantLock());

    public GroupParentCommand(LocaleManager locale) {
        super(CommandSpec.GROUP.localize(locale), "Group", ParentCommand.Type.TAKES_ARGUMENT_FOR_TARGET, ImmutableList.builder().add((Object)new GroupInfo(locale)).add(new CommandPermission(locale, HolderType.GROUP)).add(new CommandParent(locale, HolderType.GROUP)).add(new CommandMeta(locale, HolderType.GROUP)).add(new HolderEditor(locale, HolderType.GROUP)).add((Object)new GroupListMembers(locale)).add((Object)new GroupSetWeight(locale)).add((Object)new GroupSetDisplayName(locale)).add(new HolderShowTracks(locale, HolderType.GROUP)).add(new HolderClear(locale, HolderType.GROUP)).add((Object)new GroupRename(locale)).add((Object)new GroupClone(locale)).build());
    }

    @Override
    protected String parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        Group group = plugin.getGroupManager().getByDisplayName(target);
        if (group != null) {
            return group.getName();
        }
        return target.toLowerCase();
    }

    @Override
    protected Group getTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        return StorageAssistant.loadGroup(target, sender, plugin, true);
    }

    @Override
    protected ReentrantLock getLockForTarget(String target) {
        return (ReentrantLock)this.locks.get((Object)target);
    }

    @Override
    protected void cleanup(Group group, LuckPermsPlugin plugin) {
    }

    @Override
    protected List<String> getTargets(LuckPermsPlugin plugin) {
        return new ArrayList<String>(plugin.getGroupManager().getAll().keySet());
    }
}

