/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import com.google.common.collect.Multimap;
import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.event.cause.DeletionCause;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class GroupRename
extends ChildCommand<Group> {
    public GroupRename(LocaleManager locale) {
        super(CommandSpec.GROUP_RENAME.localize(locale), "rename", CommandPermission.GROUP_RENAME, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Group group, List<String> args, String label) {
        Group newGroup;
        String newGroupName = args.get(0).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(newGroupName)) {
            Message.GROUP_INVALID_ENTRY.send(sender, newGroupName);
            return CommandResult.INVALID_ARGS;
        }
        if (plugin.getStorage().loadGroup(newGroupName).join().isPresent()) {
            Message.ALREADY_EXISTS.send(sender, newGroupName);
            return CommandResult.INVALID_ARGS;
        }
        try {
            newGroup = plugin.getStorage().createAndLoadGroup(newGroupName, CreationCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.CREATE_ERROR.send(sender, newGroupName);
            return CommandResult.FAILURE;
        }
        try {
            plugin.getStorage().deleteGroup(group, DeletionCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.DELETE_ERROR.send(sender, group.getFormattedDisplayName());
            return CommandResult.FAILURE;
        }
        newGroup.replaceNodes(DataType.NORMAL, (Multimap<ImmutableContextSet, ? extends Node>)group.normalData().immutable());
        Message.RENAME_SUCCESS.send(sender, group.getName(), newGroup.getName());
        LoggedAction.build().source(sender).target(group).description("rename", newGroup.getName()).build().submit(plugin, sender);
        StorageAssistant.save(newGroup, sender, plugin);
        return CommandResult.SUCCESS;
    }
}

