/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.node.types.DisplayName;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.DisplayNameNode;

public class GroupSetDisplayName
extends ChildCommand<Group> {
    public GroupSetDisplayName(LocaleManager locale) {
        super(CommandSpec.GROUP_SET_DISPLAY_NAME.localize(locale), "setdisplayname", CommandPermission.GROUP_SET_DISPLAY_NAME, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Group group, List<String> args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), group)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        String name = ArgumentParser.parseString(0, args);
        ImmutableContextSet context = ArgumentParser.parseContext(1, args, plugin).immutableCopy();
        String previousName = group.normalData().immutable().get((Object)context).stream().filter(NodeType.DISPLAY_NAME::matches).map(NodeType.DISPLAY_NAME::cast).findFirst().map(DisplayNameNode::getDisplayName).orElse(null);
        if (previousName == null && name.equals(group.getName())) {
            Message.GROUP_SET_DISPLAY_NAME_DOESNT_HAVE.send(sender, group.getName());
            return CommandResult.STATE_ERROR;
        }
        if (name.equals(previousName)) {
            Message.GROUP_SET_DISPLAY_NAME_ALREADY_HAS.send(sender, group.getName(), name);
            return CommandResult.STATE_ERROR;
        }
        Group existing = plugin.getGroupManager().getByDisplayName(name);
        if (existing != null && !group.equals(existing)) {
            Message.GROUP_SET_DISPLAY_NAME_ALREADY_IN_USE.send(sender, name, existing.getName());
            return CommandResult.STATE_ERROR;
        }
        group.removeIf(DataType.NORMAL, context, NodeType.DISPLAY_NAME::matches, false);
        if (name.equals(group.getName())) {
            Message.GROUP_SET_DISPLAY_NAME_REMOVED.send(sender, group.getName(), MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
            LoggedAction.build().source(sender).target(group).description("setdisplayname", name, context).build().submit(plugin, sender);
            StorageAssistant.save(group, sender, plugin);
            return CommandResult.SUCCESS;
        }
        group.setNode(DataType.NORMAL, (Node)((DisplayNameNode.Builder)DisplayName.builder(name).withContext(context)).build(), true);
        Message.GROUP_SET_DISPLAY_NAME.send(sender, name, group.getName(), MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
        LoggedAction.build().source(sender).target(group).description("setdisplayname", name, context).build().submit(plugin, sender);
        StorageAssistant.save(group, sender, plugin);
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().from(1, TabCompletions.contexts(plugin)).complete(args);
    }
}

