/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.node.types.Weight;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;

public class GroupSetWeight
extends ChildCommand<Group> {
    public GroupSetWeight(LocaleManager locale) {
        super(CommandSpec.GROUP_SETWEIGHT.localize(locale), "setweight", CommandPermission.GROUP_SET_WEIGHT, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Group group, List<String> args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), group)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        int weight = ArgumentParser.parsePriority(0, args);
        group.removeIf(DataType.NORMAL, null, NodeType.WEIGHT::matches, false);
        group.setNode(DataType.NORMAL, (Node)Weight.builder(weight).build(), true);
        Message.GROUP_SET_WEIGHT.send(sender, weight, group.getFormattedDisplayName());
        LoggedAction.build().source(sender).target(group).description("setweight", weight).build().submit(plugin, sender);
        StorageAssistant.save(group, sender, plugin);
        return CommandResult.SUCCESS;
    }
}

