/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Paginated;
import me.lucko.luckperms.common.util.Predicates;

public class LogSearch
extends ChildCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogSearch(LocaleManager locale) {
        super(CommandSpec.LOG_SEARCH.localize(locale), "search", CommandPermission.LOG_SEARCH, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, List<String> args, String label) {
        int page = Integer.MIN_VALUE;
        if (args.size() > 1) {
            try {
                page = Integer.parseInt(args.get(args.size() - 1));
                args.remove(args.size() - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String query = String.join((CharSequence)" ", args);
        Paginated<LoggedAction> content = new Paginated<LoggedAction>(log.getSearch(query));
        if (page != Integer.MIN_VALUE) {
            return LogSearch.showLog(page, query, sender, content);
        }
        return LogSearch.showLog(content.getMaxPages(10), query, sender, content);
    }

    private static CommandResult showLog(int page, String query, Sender sender, Paginated<LoggedAction> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        if (page == Integer.MIN_VALUE) {
            page = maxPage;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return CommandResult.INVALID_ARGS;
        }
        List<Paginated.Entry<LoggedAction>> entries = log.getPage(page, 10);
        Message.LOG_SEARCH_HEADER.send(sender, query, page, maxPage);
        for (Paginated.Entry<LoggedAction> e : entries) {
            Message.LOG_ENTRY.send(sender, e.position(), DurationFormatter.CONCISE_LOW_ACCURACY.format(e.value().getDurationSince()), e.value().getSourceFriendlyString(), Character.toString(LoggedAction.getTypeCharacter(e.value().getTarget().getType())), e.value().getTargetFriendlyString(), e.value().getDescription());
        }
        return CommandResult.SUCCESS;
    }
}

