/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Paginated;
import me.lucko.luckperms.common.util.Predicates;

public class LogUserHistory
extends ChildCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogUserHistory(LocaleManager locale) {
        super(CommandSpec.LOG_USER_HISTORY.localize(locale), "userhistory", CommandPermission.LOG_USER_HISTORY, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, List<String> args, String label) {
        UUID uuid = ArgumentParser.parseUserTarget(0, args, plugin, sender);
        if (uuid == null) {
            return CommandResult.INVALID_ARGS;
        }
        Paginated<LoggedAction> content = new Paginated<LoggedAction>(log.getUserHistory(uuid));
        int page = ArgumentParser.parseIntOrElse(1, args, Integer.MIN_VALUE);
        if (page != Integer.MIN_VALUE) {
            return LogUserHistory.showLog(page, sender, content);
        }
        return LogUserHistory.showLog(content.getMaxPages(10), sender, content);
    }

    private static CommandResult showLog(int page, Sender sender, Paginated<LoggedAction> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return CommandResult.INVALID_ARGS;
        }
        List<Paginated.Entry<LoggedAction>> entries = log.getPage(page, 10);
        String name = ((LoggedAction)((Paginated.Entry)entries.stream().findAny().get()).value()).getTarget().getName();
        Message.LOG_HISTORY_USER_HEADER.send(sender, name, page, maxPage);
        for (Paginated.Entry<LoggedAction> e : entries) {
            Message.LOG_ENTRY.send(sender, e.position(), DurationFormatter.CONCISE_LOW_ACCURACY.format(e.value().getDurationSince()), e.value().getSourceFriendlyString(), Character.toString(LoggedAction.getTypeCharacter(e.value().getTarget().getType())), e.value().getTargetFriendlyString(), e.value().getDescription());
        }
        return CommandResult.SUCCESS;
    }
}

