/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.Uuids;
import me.lucko.luckperms.common.web.UnsuccessfulRequestException;
import me.lucko.luckperms.common.web.WebEditor;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.event.cause.DeletionCause;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class ApplyEditsCommand
extends SingleCommand {
    public ApplyEditsCommand(LocaleManager locale) {
        super(CommandSpec.APPLY_EDITS.localize(locale), "ApplyEdits", CommandPermission.APPLY_EDITS, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        JsonObject data;
        String code = args.get(0);
        if (code.isEmpty()) {
            Message.APPLY_EDITS_INVALID_CODE.send(sender, code);
            return CommandResult.INVALID_ARGS;
        }
        try {
            data = WebEditor.readDataFromBytebin(plugin.getBytebin(), code);
        }
        catch (UnsuccessfulRequestException e) {
            Message.EDITOR_HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
            return CommandResult.STATE_ERROR;
        }
        catch (IOException e) {
            new RuntimeException("Error uploading data to bytebin", e).printStackTrace();
            Message.EDITOR_HTTP_UNKNOWN_FAILURE.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        if (data == null) {
            Message.APPLY_EDITS_UNABLE_TO_READ.send(sender, code);
            return CommandResult.FAILURE;
        }
        boolean work = false;
        if (data.has("changes")) {
            JsonArray changes = data.get("changes").getAsJsonArray();
            for (JsonElement change : changes) {
                if (!this.readChanges(change.getAsJsonObject(), sender, plugin)) continue;
                work = true;
            }
        }
        if (data.has("groupDeletions")) {
            JsonArray groupDeletions = data.get("groupDeletions").getAsJsonArray();
            for (JsonElement groupDeletion : groupDeletions) {
                if (!this.readGroupDeletion(groupDeletion, sender, plugin)) continue;
                work = true;
            }
        }
        if (data.has("trackDeletions")) {
            JsonArray trackDeletions = data.get("trackDeletions").getAsJsonArray();
            for (JsonElement trackDeletion : trackDeletions) {
                if (!this.readTrackDeletion(trackDeletion, sender, plugin)) continue;
                work = true;
            }
        }
        if (!work) {
            Message.APPLY_EDITS_TARGET_NO_CHANGES_PRESENT.send(sender, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    private boolean readChanges(JsonObject data, Sender sender, LuckPermsPlugin plugin) {
        String type = data.get("type").getAsString();
        if (type.equals("user") || type.equals("group")) {
            return this.readHolderChanges(data, sender, plugin);
        }
        if (type.equals("track")) {
            return this.readTrackChanges(data, sender, plugin);
        }
        Message.APPLY_EDITS_UNKNOWN_TYPE.send(sender, type);
        return false;
    }

    private boolean readHolderChanges(JsonObject data, Sender sender, LuckPermsPlugin plugin) {
        PermissionHolder holder;
        String type = data.get("type").getAsString();
        String id = data.get("id").getAsString();
        if (type.equals("user")) {
            UUID uuid = Uuids.parse(id);
            if (uuid == null) {
                Message.APPLY_EDITS_TARGET_USER_NOT_UUID.send(sender, id);
                return false;
            }
            holder = plugin.getStorage().loadUser(uuid, null).join();
            if (holder == null) {
                Message.APPLY_EDITS_TARGET_USER_UNABLE_TO_LOAD.send(sender, uuid.toString());
                return false;
            }
        } else {
            holder = plugin.getStorage().loadGroup(id).join().orElse(null);
            if (holder == null) {
                holder = plugin.getStorage().createAndLoadGroup(id, CreationCause.WEB_EDITOR).join();
            }
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return false;
        }
        HashSet before = new HashSet(holder.normalData().immutable().values());
        HashSet<Node> after = new HashSet<Node>(NodeJsonSerializer.deserializeNodes(data.getAsJsonArray("nodes")));
        Set<Node> diffAdded = ApplyEditsCommand.getAdded(before, after);
        Set<Node> diffRemoved = ApplyEditsCommand.getRemoved(before, after);
        int additions = diffAdded.size();
        int deletions = diffRemoved.size();
        if (additions == 0 && deletions == 0) {
            return false;
        }
        holder.setNodes(DataType.NORMAL, after);
        for (Node n : diffAdded) {
            LoggedAction.build().source(sender).target(holder).description("webeditor", "add", n.getKey(), n.getValue(), n.getContexts()).build().submit(plugin, sender);
        }
        for (Node n : diffRemoved) {
            LoggedAction.build().source(sender).target(holder).description("webeditor", "remove", n.getKey(), n.getValue(), n.getContexts()).build().submit(plugin, sender);
        }
        String additionsSummary = "addition" + (additions == 1 ? "" : "s");
        String deletionsSummary = "deletion" + (deletions == 1 ? "" : "s");
        Message.APPLY_EDITS_SUCCESS.send(sender, type, holder.getFormattedDisplayName());
        Message.APPLY_EDITS_SUCCESS_SUMMARY.send(sender, additions, additionsSummary, deletions, deletionsSummary);
        for (Node n : diffAdded) {
            Message.APPLY_EDITS_DIFF_ADDED.send(sender, ApplyEditsCommand.formatNode(plugin.getLocaleManager(), n));
        }
        for (Node n : diffRemoved) {
            Message.APPLY_EDITS_DIFF_REMOVED.send(sender, ApplyEditsCommand.formatNode(plugin.getLocaleManager(), n));
        }
        StorageAssistant.save(holder, sender, plugin);
        return true;
    }

    private boolean readTrackChanges(JsonObject data, Sender sender, LuckPermsPlugin plugin) {
        String id = data.get("id").getAsString();
        Track track = plugin.getStorage().loadTrack(id).join().orElse(null);
        if (track == null) {
            track = plugin.getStorage().createAndLoadTrack(id, CreationCause.WEB_EDITOR).join();
        }
        List<String> before = track.getGroups();
        ArrayList<String> after = new ArrayList<String>();
        data.getAsJsonArray("groups").forEach(e -> after.add(e.getAsString()));
        if (before.equals(after)) {
            return false;
        }
        Set<String> diffAdded = ApplyEditsCommand.getAdded(before, after);
        Set<String> diffRemoved = ApplyEditsCommand.getRemoved(before, after);
        int additions = diffAdded.size();
        int deletions = diffRemoved.size();
        track.setGroups(after);
        if (ApplyEditsCommand.hasBeenReordered(before, after, diffAdded, diffRemoved)) {
            LoggedAction.build().source(sender).target(track).description("webeditor", "reorder", after).build().submit(plugin, sender);
        }
        for (String n : diffAdded) {
            LoggedAction.build().source(sender).target(track).description("webeditor", "add", n).build().submit(plugin, sender);
        }
        for (String n : diffRemoved) {
            LoggedAction.build().source(sender).target(track).description("webeditor", "remove", n).build().submit(plugin, sender);
        }
        String additionsSummary = "addition" + (additions == 1 ? "" : "s");
        String deletionsSummary = "deletion" + (deletions == 1 ? "" : "s");
        Message.APPLY_EDITS_SUCCESS.send(sender, "track", track.getName());
        Message.APPLY_EDITS_SUCCESS_SUMMARY.send(sender, additions, additionsSummary, deletions, deletionsSummary);
        Message.APPLY_EDITS_DIFF_REMOVED.send(sender, before);
        Message.APPLY_EDITS_DIFF_ADDED.send(sender, after);
        StorageAssistant.save(track, sender, plugin);
        return true;
    }

    private boolean readGroupDeletion(JsonElement data, Sender sender, LuckPermsPlugin plugin) {
        String groupName = data.getAsString();
        if (groupName.equalsIgnoreCase("default")) {
            Message.DELETE_GROUP_ERROR_DEFAULT.send(sender, new Object[0]);
            return true;
        }
        Group group = plugin.getStorage().loadGroup(groupName).join().orElse(null);
        if (group == null) {
            return false;
        }
        try {
            plugin.getStorage().deleteGroup(group, DeletionCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.DELETE_ERROR.send(sender, group.getFormattedDisplayName());
            return true;
        }
        Message.DELETE_SUCCESS.send(sender, group.getFormattedDisplayName());
        LoggedAction.build().source(sender).targetName(groupName).targetType(Action.Target.Type.GROUP).description("webeditor", "delete").build().submit(plugin, sender);
        return true;
    }

    private boolean readTrackDeletion(JsonElement data, Sender sender, LuckPermsPlugin plugin) {
        String trackName = data.getAsString();
        Track track = plugin.getStorage().loadTrack(trackName).join().orElse(null);
        if (track == null) {
            return false;
        }
        try {
            plugin.getStorage().deleteTrack(track, DeletionCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.DELETE_ERROR.send(sender, track.getName());
            return true;
        }
        Message.DELETE_SUCCESS.send(sender, trackName);
        LoggedAction.build().source(sender).targetName(trackName).targetType(Action.Target.Type.TRACK).description("webeditor", "delete").build().submit(plugin, sender);
        return true;
    }

    private static String formatNode(LocaleManager localeManager, Node n) {
        return n.getKey() + " &7(" + (n.getValue() ? "&a" : "&c") + n.getValue() + "&7)" + MessageUtils.getAppendableNodeContextString(localeManager, n) + (n.hasExpiry() ? " &7(" + DurationFormatter.CONCISE.format(n.getExpiryDuration()) + ")" : "");
    }

    private static <T> Set<T> getAdded(Collection<T> before, Collection<T> after) {
        LinkedHashSet<T> added = new LinkedHashSet<T>(after);
        added.removeAll(before);
        return added;
    }

    private static <T> Set<T> getRemoved(Collection<T> before, Collection<T> after) {
        LinkedHashSet<T> removed = new LinkedHashSet<T>(before);
        removed.removeAll(after);
        return removed;
    }

    private static <T> boolean hasBeenReordered(List<T> before, List<T> after, Collection<T> diffAdded, Collection<T> diffRemoved) {
        after = new ArrayList<T>(after);
        before = new ArrayList<T>(before);
        after.removeAll(diffAdded);
        before.removeAll(diffRemoved);
        return !before.equals(after);
    }

    @Override
    public boolean shouldDisplay() {
        return false;
    }
}

