/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.Uuids;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import net.luckperms.api.util.Tristate;

public class CheckCommand
extends SingleCommand {
    public CheckCommand(LocaleManager locale) {
        super(CommandSpec.CHECK.localize(locale), "Check", CommandPermission.CHECK, Predicates.not(2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        String target = args.get(0);
        String permission = args.get(1);
        UUID u = Uuids.parse(target);
        User user = u != null ? plugin.getUserManager().getIfLoaded(u) : plugin.getUserManager().getByUsername(target);
        if (user == null) {
            Message.USER_NOT_ONLINE.send(sender, target);
            return CommandResult.STATE_ERROR;
        }
        Tristate tristate = user.getCachedData().getPermissionData(user.getQueryOptions()).checkPermission(permission, PermissionCheckEvent.Origin.INTERNAL).result();
        Message.CHECK_RESULT.send(sender, user.getFormattedDisplayName(), permission, MessageUtils.formatTristate(tristate));
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> plugin.getBootstrap().getPlayerList().stream())).at(1, TabCompletions.permissions(plugin)).complete(args);
    }
}

