/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import me.lucko.luckperms.common.web.WebEditor;
import net.luckperms.api.query.QueryOptions;

public class EditorCommand
extends SingleCommand {
    private static final int MAX_USERS = 1000;

    public EditorCommand(LocaleManager locale) {
        super(CommandSpec.EDITOR.localize(locale), "Editor", CommandPermission.EDITOR, Predicates.notInRange(0, 1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        Type type = Type.ALL;
        String typeString = ArgumentParser.parseStringOrElse(0, args, null);
        if (typeString != null) {
            try {
                type = Type.valueOf(typeString.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        plugin.getSyncTaskBuffer().requestDirectly();
        ArrayList<PermissionHolder> holders = new ArrayList<PermissionHolder>();
        ArrayList<Track> tracks = new ArrayList<Track>();
        if (type.includingGroups) {
            plugin.getGroupManager().getAll().values().stream().sorted(Comparator.comparingInt(g -> g.getWeight().orElse(0)).reversed().thenComparing(Group::getName, String.CASE_INSENSITIVE_ORDER)).forEach(holders::add);
            tracks.addAll(plugin.getTrackManager().getAll().values());
        }
        if (type.includingUsers) {
            LinkedHashMap users = new LinkedHashMap(plugin.getUserManager().getAll());
            if (type.includingOffline && users.size() < 1000) {
                plugin.getStorage().getUniqueUsers().join().stream().filter(uuid -> !users.containsKey(uuid)).sorted().limit(1000 - users.size()).forEach(uuid -> {
                    User user = plugin.getStorage().loadUser((UUID)uuid, null).join();
                    if (user != null) {
                        users.put(uuid, user);
                    }
                    plugin.getUserManager().getHouseKeeper().cleanup((UUID)uuid);
                });
            }
            users.values().stream().sorted(Comparator.comparingInt(u -> u.getCachedData().getMetaData(QueryOptions.nonContextual()).getWeight(MetaCheckEvent.Origin.INTERNAL)).thenComparing(User::getFormattedDisplayName, String.CASE_INSENSITIVE_ORDER)).forEach(holders::add);
        }
        if (holders.isEmpty()) {
            Message.EDITOR_NO_MATCH.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        holders.removeIf(holder -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), holder));
        tracks.removeIf(track -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), track));
        if (holders.isEmpty() && tracks.isEmpty()) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Message.EDITOR_START.send(sender, new Object[0]);
        JsonObject payload = WebEditor.formPayload(holders, tracks, sender, label, plugin);
        return WebEditor.post(payload, sender, plugin);
    }

    private static enum Type {
        ALL(true, true, true),
        ONLINE(true, true, false),
        USERS(true, false, true),
        GROUPS(false, true, true);

        private final boolean includingUsers;
        private final boolean includingGroups;
        private final boolean includingOffline;

        private Type(boolean includingUsers, boolean includingGroups, boolean includingOffline) {
            this.includingUsers = includingUsers;
            this.includingGroups = includingGroups;
            this.includingOffline = includingOffline;
        }
    }
}

