/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import me.lucko.luckperms.common.backup.Exporter;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;

public class ExportCommand
extends SingleCommand {
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ExportCommand(LocaleManager locale) {
        super(CommandSpec.EXPORT.localize(locale), "Export", CommandPermission.EXPORT, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        boolean includeUsers;
        if (this.running.get()) {
            Message.EXPORT_ALREADY_RUNNING.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        Path dataDirectory = plugin.getBootstrap().getDataDirectory();
        Path path = dataDirectory.resolve(args.get(0) + ".json.gz");
        if (!path.getParent().equals(dataDirectory)) {
            Message.FILE_NOT_WITHIN_DIRECTORY.send(sender, path.toString());
            return CommandResult.INVALID_ARGS;
        }
        boolean bl = includeUsers = !args.remove("--without-users");
        if (Files.exists(path, new LinkOption[0])) {
            Message.LOG_EXPORT_ALREADY_EXISTS.send(sender, path.toString());
            return CommandResult.INVALID_ARGS;
        }
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            Message.LOG_EXPORT_FAILURE.send(sender, new Object[0]);
            e.printStackTrace();
            return CommandResult.FAILURE;
        }
        if (!Files.isWritable(path)) {
            Message.LOG_EXPORT_NOT_WRITABLE.send(sender, path.toString());
            return CommandResult.FAILURE;
        }
        if (!this.running.compareAndSet(false, true)) {
            Message.EXPORT_ALREADY_RUNNING.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        Exporter exporter = new Exporter(plugin, sender, path, includeUsers);
        plugin.getBootstrap().getScheduler().executeAsync(() -> {
            try {
                exporter.run();
            }
            finally {
                this.running.set(false);
            }
        });
        return CommandResult.SUCCESS;
    }
}

