/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import me.lucko.luckperms.common.backup.Importer;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.gson.GsonProvider;

public class ImportCommand
extends SingleCommand {
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ImportCommand(LocaleManager locale) {
        super(CommandSpec.IMPORT.localize(locale), "Import", CommandPermission.IMPORT, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        JsonObject data;
        Path pathWithDefaultExtension;
        if (this.running.get()) {
            Message.IMPORT_ALREADY_RUNNING.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        String fileName = args.get(0);
        Path dataDirectory = plugin.getBootstrap().getDataDirectory();
        Path path = dataDirectory.resolve(fileName);
        if (!path.getParent().equals(dataDirectory) || path.getFileName().toString().equals("config.yml")) {
            Message.FILE_NOT_WITHIN_DIRECTORY.send(sender, path.toString());
            return CommandResult.INVALID_ARGS;
        }
        if (!Files.exists(path, new LinkOption[0]) && !fileName.contains(".") && Files.exists(pathWithDefaultExtension = path.resolveSibling(fileName + ".json.gz"), new LinkOption[0])) {
            path = pathWithDefaultExtension;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Message.IMPORT_FILE_DOESNT_EXIST.send(sender, path.toString());
            return CommandResult.INVALID_ARGS;
        }
        if (!Files.isReadable(path)) {
            Message.IMPORT_FILE_NOT_READABLE.send(sender, path.toString());
            return CommandResult.FAILURE;
        }
        if (!this.running.compareAndSet(false, true)) {
            Message.IMPORT_ALREADY_RUNNING.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])), StandardCharsets.UTF_8));){
            data = (JsonObject)GsonProvider.normal().fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            Message.IMPORT_FILE_READ_FAILURE.send(sender, new Object[0]);
            this.running.set(false);
            return CommandResult.FAILURE;
        }
        Importer importer = new Importer(plugin, sender, data);
        plugin.getBootstrap().getScheduler().executeAsync(() -> {
            try {
                importer.run();
            }
            finally {
                this.running.set(false);
            }
        });
        return CommandResult.SUCCESS;
    }
}

