/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.util.List;
import java.util.Optional;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;

public class NetworkSyncCommand
extends SingleCommand {
    public NetworkSyncCommand(LocaleManager locale) {
        super(CommandSpec.NETWORK_SYNC.localize(locale), "NetworkSync", CommandPermission.SYNC, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        Message.UPDATE_TASK_REQUEST.send(sender, new Object[0]);
        plugin.getSyncTaskBuffer().request().join();
        Message.UPDATE_TASK_COMPLETE_NETWORK.send(sender, new Object[0]);
        Optional<InternalMessagingService> messagingService = plugin.getMessagingService();
        if (!messagingService.isPresent()) {
            Message.UPDATE_TASK_PUSH_FAILURE_NOT_SETUP.send(sender, new Object[0]);
            return CommandResult.FAILURE;
        }
        try {
            messagingService.get().pushUpdate();
            Message.UPDATE_TASK_PUSH_SUCCESS.send(sender, messagingService.get().getName());
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.UPDATE_TASK_PUSH_FAILURE.send(sender, new Object[0]);
            return CommandResult.FAILURE;
        }
    }
}

