/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.bulkupdate.comparison.Comparison;
import me.lucko.luckperms.common.bulkupdate.comparison.Constraint;
import me.lucko.luckperms.common.bulkupdate.comparison.StandardComparison;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.node.comparator.NodeEntryComparator;
import me.lucko.luckperms.common.node.factory.NodeCommandFactory;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.ComponentBuilder;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import net.luckperms.api.node.Node;

public class SearchCommand
extends SingleCommand {
    public SearchCommand(LocaleManager locale) {
        super(CommandSpec.SEARCH.localize(locale), "Search", CommandPermission.SEARCH, Predicates.notInRange(1, 3));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        StandardComparison comparison = StandardComparison.parseComparison(args.get(0));
        if (comparison == null) {
            comparison = StandardComparison.EQUAL;
            args.add(0, "==");
        }
        ConstraintNodeMatcher<Node> matcher = StandardNodeMatchers.of(Constraint.of(comparison, args.get(1)));
        int page = ArgumentParser.parseIntOrElse(2, args, 1);
        Message.SEARCH_SEARCHING.send(sender, matcher);
        List matchedUsers = plugin.getStorage().getUsersWithPermission(matcher).join();
        List matchedGroups = plugin.getStorage().getGroupsWithPermission(matcher).join();
        int users = matchedUsers.size();
        int groups = matchedGroups.size();
        Message.SEARCH_RESULT.send(sender, users + groups, users, groups);
        if (!matchedUsers.isEmpty()) {
            LoadingMap<UUID, String> uuidLookups = LoadingMap.of(u -> {
                String s = plugin.getStorage().getPlayerName((UUID)u).join();
                if (s != null && !s.isEmpty() && !s.equals("null")) {
                    return s;
                }
                if (plugin.getConfiguration().get(ConfigKeys.USE_SERVER_UUID_CACHE).booleanValue() && (s = (String)plugin.getBootstrap().lookupUsername((UUID)u).orElse(null)) != null) {
                    return s;
                }
                return u.toString();
            });
            SearchCommand.sendResult(sender, matchedUsers, uuidLookups::get, Message.SEARCH_SHOWING_USERS, HolderType.USER, label, page, comparison);
        }
        if (!matchedGroups.isEmpty()) {
            SearchCommand.sendResult(sender, matchedGroups, Function.identity(), Message.SEARCH_SHOWING_GROUPS, HolderType.GROUP, label, page, comparison);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.permissions(plugin)).complete(args);
    }

    private static <T extends Comparable<T>> void sendResult(Sender sender, List<NodeEntry<T, Node>> results, Function<T, String> lookupFunction, Message headerMessage, HolderType holderType, String label, int page, Comparison comparison) {
        results = new ArrayList<NodeEntry<T, Node>>(results);
        results.sort(NodeEntryComparator.normal());
        int pageIndex = page - 1;
        List<List<NodeEntry<T, Node>>> pages = Iterators.divideIterable(results, 15);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List<NodeEntry<T, Node>> content = pages.get(pageIndex);
        List mappedContent = content.stream().map(hp -> Maps.immutableEntry(lookupFunction.apply(hp.getHolder()), (Object)hp)).collect(Collectors.toList());
        headerMessage.send(sender, page, pages.size(), results.size());
        for (Map.Entry ent : mappedContent) {
            String permission = "";
            if (comparison != StandardComparison.EQUAL) {
                permission = "&7 - (" + ((NodeEntry)ent.getValue()).getNode().getKey() + ")";
            }
            String s = "&3> &b" + (String)ent.getKey() + permission + "&7 - " + (((NodeEntry)ent.getValue()).getNode().getValue() ? "&a" : "&c") + ((NodeEntry)ent.getValue()).getNode().getValue() + SearchCommand.getNodeExpiryString(((NodeEntry)ent.getValue()).getNode()) + MessageUtils.getAppendableNodeContextString(sender.getPlugin().getLocaleManager(), ((NodeEntry)ent.getValue()).getNode());
            TextComponent message = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)TextUtils.fromLegacy(s, '&').toBuilder()).applyDeep(SearchCommand.makeFancy((String)ent.getKey(), holderType, label, (NodeEntry)ent.getValue(), sender.getPlugin()))).build();
            sender.sendMessage((Component)message);
        }
    }

    private static String getNodeExpiryString(Node node) {
        if (!node.hasExpiry()) {
            return "";
        }
        return " &8(&7expires in " + DurationFormatter.LONG.format(node.getExpiryDuration()) + "&8)";
    }

    private static Consumer<ComponentBuilder<?, ?>> makeFancy(String holderName, HolderType holderType, String label, NodeEntry<?, ?> perm, LuckPermsPlugin plugin) {
        HoverEvent hoverEvent = HoverEvent.showText((Component)TextUtils.fromLegacy(TextUtils.joinNewline("&3> " + (perm.getNode().getValue() ? "&a" : "&c") + perm.getNode().getKey(), " ", "&7Click to remove this node from " + holderName), '&'));
        boolean explicitGlobalContext = !plugin.getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        String command = "/" + label + " " + NodeCommandFactory.generateCommand(perm.getNode(), holderName, holderType, false, explicitGlobalContext);
        ClickEvent clickEvent = ClickEvent.suggestCommand((String)command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }
}

