/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.treeview.TreeView;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.Uuids;
import me.lucko.luckperms.common.web.UnsuccessfulRequestException;
import me.lucko.luckperms.lib.text.BuildableComponent;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;

public class TreeCommand
extends SingleCommand {
    public TreeCommand(LocaleManager locale) {
        super(CommandSpec.TREE.localize(locale), "Tree", CommandPermission.TREE, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        String id;
        TreeView view;
        User user;
        String selection = ".";
        String player = null;
        if (!args.isEmpty()) {
            selection = args.get(0);
        }
        if (args.size() > 1) {
            player = args.get(1);
        }
        if (player != null) {
            UUID u = Uuids.parse(player);
            user = u != null ? plugin.getUserManager().getIfLoaded(u) : plugin.getUserManager().getByUsername(player);
            if (user == null) {
                Message.USER_NOT_ONLINE.send(sender, player);
                return CommandResult.STATE_ERROR;
            }
        } else {
            user = null;
        }
        if (!(view = new TreeView(plugin.getPermissionRegistry(), selection)).hasData()) {
            Message.TREE_EMPTY.send(sender, new Object[0]);
            return CommandResult.FAILURE;
        }
        Message.TREE_UPLOAD_START.send(sender, new Object[0]);
        PermissionCache permissionData = user == null ? null : user.getCachedData().getPermissionData(user.getQueryOptions());
        try {
            id = view.uploadPasteData(plugin.getBytebin(), sender, user, permissionData);
        }
        catch (UnsuccessfulRequestException e) {
            Message.GENERIC_HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
            return CommandResult.STATE_ERROR;
        }
        catch (IOException e) {
            new RuntimeException("Error uploading data to bytebin", e).printStackTrace();
            Message.GENERIC_HTTP_UNKNOWN_FAILURE.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        String url = plugin.getConfiguration().get(ConfigKeys.TREE_VIEWER_URL_PATTERN) + id;
        Message.TREE_URL.send(sender, new Object[0]);
        BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)url).color(TextColor.AQUA)).clickEvent(ClickEvent.openUrl((String)url))).hoverEvent(HoverEvent.showText((Component)TextComponent.of((String)"Click to open the tree view.").color(TextColor.GRAY)))).build();
        sender.sendMessage((Component)message);
        return CommandResult.SUCCESS;
    }
}

