/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.verbose.InvalidFilterException;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.VerboseListener;
import me.lucko.luckperms.common.web.UnsuccessfulRequestException;
import me.lucko.luckperms.lib.text.BuildableComponent;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;

public class VerboseCommand
extends SingleCommand {
    public VerboseCommand(LocaleManager locale) {
        super(CommandSpec.VERBOSE.localize(locale), "Verbose", CommandPermission.VERBOSE, Predicates.is(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String mode = args.get(0).toLowerCase();
        if (mode.equals("on") || mode.equals("true") || mode.equals("record")) {
            VerboseFilter compiledFilter;
            ArrayList<String> filters = new ArrayList<String>();
            if (args.size() != 1) {
                filters.addAll(args.subList(1, args.size()));
            }
            String filter = filters.isEmpty() ? "" : String.join((CharSequence)" ", filters);
            try {
                compiledFilter = new VerboseFilter(filter);
            }
            catch (InvalidFilterException e) {
                Message.VERBOSE_INVALID_FILTER.send(sender, filter, e.getCause().getMessage());
                return CommandResult.FAILURE;
            }
            boolean notify = !mode.equals("record");
            plugin.getVerboseHandler().registerListener(sender, compiledFilter, notify);
            if (notify) {
                if (!filter.equals("")) {
                    Message.VERBOSE_ON_QUERY.send(sender, filter);
                    return CommandResult.SUCCESS;
                } else {
                    Message.VERBOSE_ON.send(sender, new Object[0]);
                }
                return CommandResult.SUCCESS;
            } else if (!filter.equals("")) {
                Message.VERBOSE_RECORDING_ON_QUERY.send(sender, filter);
                return CommandResult.SUCCESS;
            } else {
                Message.VERBOSE_RECORDING_ON.send(sender, new Object[0]);
            }
            return CommandResult.SUCCESS;
        }
        if (mode.equals("off") || mode.equals("false") || mode.equals("paste") || mode.equals("upload")) {
            VerboseListener listener = plugin.getVerboseHandler().unregisterListener(sender.getUniqueId());
            if (mode.equals("paste") || mode.equals("upload")) {
                String id;
                if (listener == null) {
                    Message.VERBOSE_OFF.send(sender, new Object[0]);
                    return CommandResult.SUCCESS;
                }
                Message.VERBOSE_UPLOAD_START.send(sender, new Object[0]);
                try {
                    id = listener.uploadPasteData(plugin.getBytebin());
                }
                catch (UnsuccessfulRequestException e) {
                    Message.GENERIC_HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
                    return CommandResult.STATE_ERROR;
                }
                catch (IOException e) {
                    new RuntimeException("Error uploading data to bytebin", e).printStackTrace();
                    Message.GENERIC_HTTP_UNKNOWN_FAILURE.send(sender, new Object[0]);
                    return CommandResult.STATE_ERROR;
                }
                String url = plugin.getConfiguration().get(ConfigKeys.VERBOSE_VIEWER_URL_PATTERN) + id;
                Message.VERBOSE_RESULTS_URL.send(sender, new Object[0]);
                BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)url).color(TextColor.AQUA)).clickEvent(ClickEvent.openUrl((String)url))).hoverEvent(HoverEvent.showText((Component)TextComponent.of((String)"Click to open the results page.").color(TextColor.GRAY)))).build();
                sender.sendMessage((Component)message);
                return CommandResult.SUCCESS;
            }
            Message.VERBOSE_OFF.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        this.sendUsage(sender, label);
        return CommandResult.INVALID_ARGS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        if (args.isEmpty()) {
            return ImmutableList.of((Object)"on", (Object)"record", (Object)"off", (Object)"upload");
        }
        if (args.size() == 1) {
            return Stream.of("on", "record", "off", "upload").filter(s -> s.toLowerCase().startsWith(((String)args.get(0)).toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

