/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.model.data.DataMutateResult;

public class TrackRemove
extends ChildCommand<Track> {
    public TrackRemove(LocaleManager locale) {
        super(CommandSpec.TRACK_REMOVE.localize(locale), "remove", CommandPermission.TRACK_REMOVE, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Track track, List<String> args, String label) {
        String groupName = args.get(0).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(groupName)) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        DataMutateResult result = track.removeGroup(groupName);
        if (result.wasSuccessful()) {
            Message.TRACK_REMOVE_SUCCESS.send(sender, groupName, track.getName());
            if (track.getGroups().size() > 1) {
                Message.BLANK.send(sender, MessageUtils.listToArrowSep(track.getGroups()));
            }
            LoggedAction.build().source(sender).target(track).description("remove", groupName).build().submit(plugin, sender);
            StorageAssistant.save(track, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.TRACK_DOES_NOT_CONTAIN.send(sender, track.getName(), groupName);
        return CommandResult.STATE_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).complete(args);
    }
}

