/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.cacheddata.type.MetaCache;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;

public class UserInfo
extends ChildCommand<User> {
    public UserInfo(LocaleManager locale) {
        super(CommandSpec.USER_INFO.localize(locale), "info", CommandPermission.USER_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, User user, List<String> args, String label) {
        String sussexValue;
        MetaCache data;
        String prefixValue;
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), user)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Message status = plugin.getBootstrap().isPlayerOnline(user.getUniqueId()) ? Message.PLAYER_ONLINE : Message.PLAYER_OFFLINE;
        Message.USER_INFO_GENERAL.send(sender, user.getUsername().orElse("Unknown"), user.getUniqueId(), user.getUniqueId().version() == 4 ? "&2mojang" : "&8offline", status.asString(plugin.getLocaleManager(), new Object[0]));
        List parents = user.normalData().inheritanceAsSortedSet().stream().filter(Node::getValue).filter(n -> !n.hasExpiry()).collect(Collectors.toList());
        List tempParents = user.normalData().inheritanceAsSortedSet().stream().filter(Node::getValue).filter(Node::hasExpiry).collect(Collectors.toList());
        if (!parents.isEmpty()) {
            Message.INFO_PARENT_HEADER.send(sender, new Object[0]);
            for (InheritanceNode node : parents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
            }
        }
        if (!tempParents.isEmpty()) {
            Message.INFO_TEMP_PARENT_HEADER.send(sender, new Object[0]);
            for (InheritanceNode node : tempParents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
                Message.INFO_PARENT_ENTRY_EXPIRY.send(sender, DurationFormatter.LONG.format(node.getExpiryDuration()));
            }
        }
        QueryOptions queryOptions = plugin.getQueryOptionsForUser(user).orElse(null);
        boolean active = true;
        if (queryOptions == null) {
            active = false;
            queryOptions = plugin.getContextManager().getStaticQueryOptions();
        }
        String context = "&bNone";
        String prefix = "&bNone";
        String suffix = "&bNone";
        String meta = "&bNone";
        ImmutableContextSet contextSet = queryOptions.context();
        if (!contextSet.isEmpty()) {
            context = contextSet.toSet().stream().map(e -> MessageUtils.contextToString(plugin.getLocaleManager(), e.getKey(), e.getValue())).collect(Collectors.joining(" "));
        }
        if ((prefixValue = (data = user.getCachedData().getMetaData(queryOptions)).getPrefix(MetaCheckEvent.Origin.INTERNAL)) != null) {
            prefix = "&f\"" + prefixValue + "&f\"";
        }
        if ((sussexValue = data.getSuffix(MetaCheckEvent.Origin.INTERNAL)) != null) {
            suffix = "&f\"" + sussexValue + "&f\"";
        }
        String primaryGroup = user.getCachedData().getMetaData(queryOptions).getPrimaryGroup(MetaCheckEvent.Origin.INTERNAL);
        Map<String, List<String>> metaMap = data.getMeta(MetaCheckEvent.Origin.INTERNAL);
        if (!metaMap.isEmpty()) {
            meta = metaMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> Maps.immutableEntry(entry.getKey(), (Object)value))).map(e -> MessageUtils.contextToString(plugin.getLocaleManager(), (String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(" "));
        }
        Message.USER_INFO_CONTEXTUAL_DATA.send(sender, active ? "&2active player" : "&8server", context, prefix, suffix, primaryGroup, meta);
        return CommandResult.SUCCESS;
    }
}

