/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.common.command.abstraction.ParentCommand;
import me.lucko.luckperms.common.commands.generic.meta.CommandMeta;
import me.lucko.luckperms.common.commands.generic.other.HolderClear;
import me.lucko.luckperms.common.commands.generic.other.HolderEditor;
import me.lucko.luckperms.common.commands.generic.other.HolderShowTracks;
import me.lucko.luckperms.common.commands.generic.parent.CommandParent;
import me.lucko.luckperms.common.commands.generic.permission.CommandPermission;
import me.lucko.luckperms.common.commands.user.UserClone;
import me.lucko.luckperms.common.commands.user.UserDemote;
import me.lucko.luckperms.common.commands.user.UserInfo;
import me.lucko.luckperms.common.commands.user.UserPromote;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.common.util.Uuids;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;

public class UserParentCommand
extends ParentCommand<User, UserIdentifier> {
    private final LoadingCache<UUID, ReentrantLock> locks = CaffeineFactory.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(key -> new ReentrantLock());

    public UserParentCommand(LocaleManager locale) {
        super(CommandSpec.USER.localize(locale), "User", ParentCommand.Type.TAKES_ARGUMENT_FOR_TARGET, ImmutableList.builder().add((Object)new UserInfo(locale)).add(new CommandPermission(locale, HolderType.USER)).add(new CommandParent(locale, HolderType.USER)).add(new CommandMeta(locale, HolderType.USER)).add(new HolderEditor(locale, HolderType.USER)).add((Object)new UserPromote(locale)).add((Object)new UserDemote(locale)).add(new HolderShowTracks(locale, HolderType.USER)).add(new HolderClear(locale, HolderType.USER)).add((Object)new UserClone(locale)).build());
    }

    public static UUID parseTargetUniqueId(String target, LuckPermsPlugin plugin, Sender sender) {
        UUID uniqueId = Uuids.parse(target);
        if (uniqueId == null) {
            if (!plugin.getConfiguration().get(ConfigKeys.ALLOW_INVALID_USERNAMES).booleanValue()) {
                if (!DataConstraints.PLAYER_USERNAME_TEST.test(target)) {
                    Message.USER_INVALID_ENTRY.send(sender, target);
                    return null;
                }
            } else if (!DataConstraints.PLAYER_USERNAME_TEST_LENIENT.test(target)) {
                Message.USER_INVALID_ENTRY.send(sender, target);
                return null;
            }
            if ((uniqueId = plugin.getStorage().getPlayerUniqueId(target.toLowerCase()).join()) == null) {
                if (!plugin.getConfiguration().get(ConfigKeys.USE_SERVER_UUID_CACHE).booleanValue()) {
                    Message.USER_NOT_FOUND.send(sender, target);
                    return null;
                }
                uniqueId = plugin.getBootstrap().lookupUniqueId(target).orElse(null);
                if (uniqueId == null) {
                    Message.USER_NOT_FOUND.send(sender, target);
                    return null;
                }
            }
        }
        return uniqueId;
    }

    @Override
    protected UserIdentifier parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        UUID uniqueId = UserParentCommand.parseTargetUniqueId(target, plugin, sender);
        if (uniqueId == null) {
            return null;
        }
        String name = plugin.getStorage().getPlayerName(uniqueId).join();
        return UserIdentifier.of(uniqueId, name);
    }

    @Override
    protected User getTarget(UserIdentifier target, LuckPermsPlugin plugin, Sender sender) {
        User user = plugin.getStorage().loadUser(target.getUniqueId(), target.getUsername().orElse(null)).join();
        user.auditTemporaryNodes();
        return user;
    }

    @Override
    protected ReentrantLock getLockForTarget(UserIdentifier target) {
        return (ReentrantLock)this.locks.get((Object)target.getUniqueId());
    }

    @Override
    protected void cleanup(User user, LuckPermsPlugin plugin) {
        plugin.getUserManager().getHouseKeeper().cleanup(user.getUniqueId());
    }

    @Override
    protected List<String> getTargets(LuckPermsPlugin plugin) {
        return new ArrayList<String>(plugin.getBootstrap().getPlayerList());
    }
}

