/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config;

import me.lucko.luckperms.common.config.ConfigKey;
import me.lucko.luckperms.common.config.ConfigKeyTypes;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.ContextsFile;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.config.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public class AbstractConfiguration
implements LuckPermsConfiguration {
    private Object[] values = null;
    private final LuckPermsPlugin plugin;
    private final ConfigurationAdapter adapter;
    private final ContextsFile contextsFile = new ContextsFile(this);

    public AbstractConfiguration(LuckPermsPlugin plugin, ConfigurationAdapter adapter) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.load();
    }

    @Override
    public <T> T get(ConfigKey<T> key) {
        return (T)this.values[key.ordinal()];
    }

    @Override
    public synchronized void load() {
        boolean reload = true;
        if (this.values == null) {
            this.values = new Object[ConfigKeys.getKeys().size()];
            reload = false;
        }
        for (ConfigKey<?> key : ConfigKeys.getKeys()) {
            if (reload && key instanceof ConfigKeyTypes.EnduringKey) continue;
            Object value = key.get(this.adapter);
            this.values[key.ordinal()] = value;
        }
        this.contextsFile.load();
    }

    @Override
    public void reload() {
        this.adapter.reload();
        this.load();
        this.getPlugin().getEventDispatcher().dispatchConfigReload();
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public ContextsFile getContextsFile() {
        return this.contextsFile;
    }
}

