/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import me.lucko.luckperms.common.cacheddata.type.SimpleMetaValueSelector;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.config.ConfigKey;
import me.lucko.luckperms.common.config.ConfigKeyTypes;
import me.lucko.luckperms.common.config.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.metastacking.SimpleMetaStackDefinition;
import me.lucko.luckperms.common.metastacking.StandardStackElements;
import me.lucko.luckperms.common.model.PrimaryGroupHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.query.QueryOptionsBuilderImpl;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorageType;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.metastacking.DuplicateRemovalFunction;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.model.data.TemporaryNodeMergeStrategy;
import net.luckperms.api.platform.Platform;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.query.meta.MetaValueSelector;

public final class ConfigKeys {
    public static final ConfigKey<String> SERVER = ConfigKeyTypes.lowercaseStringKey("server", "global");
    public static final ConfigKey<Integer> SYNC_TIME = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
        int val = c.getInteger("sync-minutes", -1);
        if (val == -1) {
            val = c.getInteger("data.sync-minutes", -1);
        }
        return val;
    }));
    public static final ConfigKey<QueryOptions> GLOBAL_QUERY_OPTIONS = ConfigKeyTypes.customKey(c -> {
        EnumSet<Flag> flags = EnumSet.of(Flag.RESOLVE_INHERITANCE);
        if (c.getBoolean("include-global", true)) {
            flags.add(Flag.INCLUDE_NODES_WITHOUT_SERVER_CONTEXT);
        }
        if (c.getBoolean("include-global-world", true)) {
            flags.add(Flag.INCLUDE_NODES_WITHOUT_WORLD_CONTEXT);
        }
        if (c.getBoolean("apply-global-groups", true)) {
            flags.add(Flag.APPLY_INHERITANCE_NODES_WITHOUT_SERVER_CONTEXT);
        }
        if (c.getBoolean("apply-global-world-groups", true)) {
            flags.add(Flag.APPLY_INHERITANCE_NODES_WITHOUT_WORLD_CONTEXT);
        }
        return new QueryOptionsBuilderImpl(QueryMode.CONTEXTUAL).flags(flags).build();
    });
    public static final ConfigKey<Boolean> USE_SERVER_UUID_CACHE = ConfigKeyTypes.booleanKey("use-server-uuid-cache", false);
    public static final ConfigKey<Boolean> ALLOW_INVALID_USERNAMES = ConfigKeyTypes.booleanKey("allow-invalid-usernames", false);
    public static final ConfigKey<Boolean> DEBUG_LOGINS = ConfigKeyTypes.booleanKey("debug-logins", false);
    public static final ConfigKey<Boolean> CANCEL_FAILED_LOGINS = ConfigKeyTypes.booleanKey("cancel-failed-logins", false);
    public static final ConfigKey<Boolean> UPDATE_CLIENT_COMMAND_LIST = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("update-client-command-list", true));
    public static final ConfigKey<Boolean> RESOLVE_COMMAND_SELECTORS = ConfigKeyTypes.booleanKey("resolve-command-selectors", false);
    public static final ConfigKey<TemporaryNodeMergeStrategy> TEMPORARY_ADD_BEHAVIOUR = ConfigKeyTypes.customKey(c -> {
        String option = c.getString("temporary-add-behaviour", "deny").toLowerCase();
        if (!(option.equals("deny") || option.equals("replace") || option.equals("accumulate"))) {
            option = "deny";
        }
        return ArgumentParser.parseTemporaryModifier(option);
    });
    public static final ConfigKey<String> PRIMARY_GROUP_CALCULATION_METHOD = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
        String option = c.getString("primary-group-calculation", "stored").toLowerCase();
        if (!(option.equals("stored") || option.equals("parents-by-weight") || option.equals("all-parents-by-weight"))) {
            option = "stored";
        }
        return option;
    }));
    public static final ConfigKey<Function<User, PrimaryGroupHolder>> PRIMARY_GROUP_CALCULATION = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
        String option;
        switch (option = PRIMARY_GROUP_CALCULATION_METHOD.get((ConfigurationAdapter)c)) {
            case "stored": {
                return PrimaryGroupHolder.Stored::new;
            }
            case "parents-by-weight": {
                return PrimaryGroupHolder.ParentsByWeight::new;
            }
        }
        return PrimaryGroupHolder.AllParentsByWeight::new;
    }));
    public static final ConfigKey<Boolean> PREVENT_PRIMARY_GROUP_REMOVAL = ConfigKeyTypes.booleanKey("prevent-primary-group-removal", true);
    public static final ConfigKey<Boolean> USE_ARGUMENT_BASED_COMMAND_PERMISSIONS = ConfigKeyTypes.booleanKey("argument-based-command-permissions", false);
    public static final ConfigKey<Boolean> REQUIRE_SENDER_GROUP_MEMBERSHIP_TO_MODIFY = ConfigKeyTypes.booleanKey("require-sender-group-membership-to-modify", false);
    public static final ConfigKey<Boolean> APPLYING_WILDCARDS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-wildcards", true));
    public static final ConfigKey<Boolean> APPLYING_WILDCARDS_SPONGE = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
        boolean def = c.getPlugin().getBootstrap().getType() == Platform.Type.SPONGE;
        return c.getBoolean("apply-sponge-implicit-wildcards", def);
    }));
    public static final ConfigKey<Boolean> APPLYING_REGEX = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-regex", true));
    public static final ConfigKey<Boolean> APPLYING_SHORTHAND = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-shorthand", true));
    public static final ConfigKey<Boolean> APPLY_BUKKIT_CHILD_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bukkit-child-permissions", true));
    public static final ConfigKey<Boolean> APPLY_BUKKIT_DEFAULT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bukkit-default-permissions", true));
    public static final ConfigKey<Boolean> APPLY_BUKKIT_ATTACHMENT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bukkit-attachment-permissions", true));
    public static final ConfigKey<Boolean> APPLY_NUKKIT_CHILD_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-nukkit-child-permissions", true));
    public static final ConfigKey<Boolean> APPLY_NUKKIT_DEFAULT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-nukkit-default-permissions", true));
    public static final ConfigKey<Boolean> APPLY_NUKKIT_ATTACHMENT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-nukkit-attachment-permissions", true));
    public static final ConfigKey<Boolean> APPLY_BUNGEE_CONFIG_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bungee-config-permissions", false));
    public static final ConfigKey<Boolean> APPLY_SPONGE_DEFAULT_SUBJECTS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-sponge-default-subjects", true));
    public static final ConfigKey<TraversalAlgorithm> INHERITANCE_TRAVERSAL_ALGORITHM = ConfigKeyTypes.customKey(c -> {
        String value = c.getString("inheritance-traversal-algorithm", "depth-first-pre-order");
        switch (value.toLowerCase()) {
            case "breadth-first": {
                return TraversalAlgorithm.BREADTH_FIRST;
            }
            case "depth-first-post-order": {
                return TraversalAlgorithm.DEPTH_FIRST_POST_ORDER;
            }
        }
        return TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER;
    });
    public static final ConfigKey<Boolean> POST_TRAVERSAL_INHERITANCE_SORT = ConfigKeyTypes.booleanKey("post-traversal-inheritance-sort", false);
    public static final ConfigKey<MetaValueSelector> META_VALUE_SELECTOR = ConfigKeyTypes.customKey(c -> {
        SimpleMetaValueSelector.Strategy defaultStrategy = SimpleMetaValueSelector.Strategy.parse(c.getString("meta-value-selection-default", "inheritance"));
        Map strategies = (Map)c.getStringMap("meta-value-selection", (Map<String, String>)ImmutableMap.of()).entrySet().stream().map(e -> {
            SimpleMetaValueSelector.Strategy parse = SimpleMetaValueSelector.Strategy.parse((String)e.getValue());
            return parse == null ? null : Maps.immutableEntry(e.getKey(), (Object)((Object)parse));
        }).filter(Objects::nonNull).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new SimpleMetaValueSelector(strategies, defaultStrategy);
    });
    public static final ConfigKey<Map<String, Integer>> GROUP_WEIGHTS = ConfigKeyTypes.customKey(c -> (Map)c.getStringMap("group-weight", (Map<String, String>)ImmutableMap.of()).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> {
        try {
            return Integer.parseInt((String)e.getValue());
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    })));
    public static final ConfigKey<MetaStackDefinition> PREFIX_FORMATTING_OPTIONS = ConfigKeyTypes.customKey(l -> {
        DuplicateRemovalFunction duplicateRemovalFunction;
        List<String> format = l.getStringList("meta-formatting.prefix.format", new ArrayList<String>());
        if (format.isEmpty()) {
            format.add("highest");
        }
        String startSpacer = l.getString("meta-formatting.prefix.start-spacer", "");
        String middleSpacer = l.getString("meta-formatting.prefix.middle-spacer", " ");
        String endSpacer = l.getString("meta-formatting.prefix.end-spacer", "");
        switch (l.getString("meta-formatting.prefix.duplicates", "").toLowerCase()) {
            case "first-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.FIRST_ONLY;
                break;
            }
            case "last-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.LAST_ONLY;
                break;
            }
            default: {
                duplicateRemovalFunction = DuplicateRemovalFunction.RETAIN_ALL;
            }
        }
        return new SimpleMetaStackDefinition(StandardStackElements.parseList(l.getPlugin(), format), duplicateRemovalFunction, startSpacer, middleSpacer, endSpacer);
    });
    public static final ConfigKey<MetaStackDefinition> SUFFIX_FORMATTING_OPTIONS = ConfigKeyTypes.customKey(l -> {
        DuplicateRemovalFunction duplicateRemovalFunction;
        List<String> format = l.getStringList("meta-formatting.suffix.format", new ArrayList<String>());
        if (format.isEmpty()) {
            format.add("highest");
        }
        String startSpacer = l.getString("meta-formatting.suffix.start-spacer", "");
        String middleSpacer = l.getString("meta-formatting.suffix.middle-spacer", " ");
        String endSpacer = l.getString("meta-formatting.suffix.end-spacer", "");
        switch (l.getString("meta-formatting.prefix.duplicates", "").toLowerCase()) {
            case "first-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.FIRST_ONLY;
                break;
            }
            case "last-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.LAST_ONLY;
                break;
            }
            default: {
                duplicateRemovalFunction = DuplicateRemovalFunction.RETAIN_ALL;
            }
        }
        return new SimpleMetaStackDefinition(StandardStackElements.parseList(l.getPlugin(), format), duplicateRemovalFunction, startSpacer, middleSpacer, endSpacer);
    });
    public static final ConfigKey<Boolean> LOG_NOTIFY = ConfigKeyTypes.booleanKey("log-notify", true);
    public static final ConfigKey<Boolean> AUTO_OP = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("auto-op", false));
    public static final ConfigKey<Boolean> OPS_ENABLED = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> AUTO_OP.get((ConfigurationAdapter)c) == false && c.getBoolean("enable-ops", true)));
    public static final ConfigKey<Boolean> COMMANDS_ALLOW_OP = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("commands-allow-op", true));
    public static final ConfigKey<Boolean> VAULT_UNSAFE_LOOKUPS = ConfigKeyTypes.booleanKey("vault-unsafe-lookups", false);
    public static final ConfigKey<String> VAULT_NPC_GROUP = ConfigKeyTypes.stringKey("vault-npc-group", "default");
    public static final ConfigKey<Boolean> VAULT_NPC_OP_STATUS = ConfigKeyTypes.booleanKey("vault-npc-op-status", false);
    public static final ConfigKey<Boolean> USE_VAULT_SERVER = ConfigKeyTypes.booleanKey("use-vault-server", true);
    public static final ConfigKey<String> VAULT_SERVER = ConfigKeyTypes.customKey(c -> {
        if (USE_VAULT_SERVER.get((ConfigurationAdapter)c).booleanValue()) {
            return c.getString("vault-server", "global").toLowerCase();
        }
        return SERVER.get((ConfigurationAdapter)c);
    });
    public static final ConfigKey<Boolean> VAULT_INCLUDING_GLOBAL = ConfigKeyTypes.booleanKey("vault-include-global", true);
    public static final ConfigKey<Boolean> VAULT_IGNORE_WORLD = ConfigKeyTypes.booleanKey("vault-ignore-world", false);
    public static final ConfigKey<Map<String, String>> WORLD_REWRITES = ConfigKeyTypes.customKey(c -> (Map)c.getStringMap("world-rewrite", (Map<String, String>)ImmutableMap.of()).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> ((String)e.getValue()).toLowerCase())));
    public static final ConfigKey<Map<String, String>> GROUP_NAME_REWRITES = ConfigKeyTypes.mapKey("group-name-rewrite");
    public static final ConfigKey<StorageCredentials> DATABASE_VALUES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
        int maxPoolSize = c.getInteger("data.pool-settings.maximum-pool-size", c.getInteger("data.pool-size", 10));
        int minIdle = c.getInteger("data.pool-settings.minimum-idle", maxPoolSize);
        int maxLifetime = c.getInteger("data.pool-settings.maximum-lifetime", 1800000);
        int connectionTimeout = c.getInteger("data.pool-settings.connection-timeout", 5000);
        ImmutableMap props = ImmutableMap.copyOf(c.getStringMap("data.pool-settings.properties", (Map<String, String>)ImmutableMap.of()));
        return new StorageCredentials(c.getString("data.address", null), c.getString("data.database", null), c.getString("data.username", null), c.getString("data.password", null), maxPoolSize, minIdle, maxLifetime, connectionTimeout, (Map<String, String>)props);
    }));
    public static final ConfigKey<String> SQL_TABLE_PREFIX = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> c.getString("data.table-prefix", c.getString("data.table_prefix", "luckperms_"))));
    public static final ConfigKey<String> MONGODB_COLLECTION_PREFIX = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> c.getString("data.mongodb-collection-prefix", c.getString("data.mongodb_collection_prefix", ""))));
    public static final ConfigKey<String> MONGODB_CONNECTION_URI = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> c.getString("data.mongodb-connection-uri", c.getString("data.mongodb_connection_URI", ""))));
    public static final ConfigKey<StorageType> STORAGE_METHOD = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> StorageType.parse(c.getString("storage-method", "h2"), StorageType.H2)));
    public static final ConfigKey<Boolean> WATCH_FILES = ConfigKeyTypes.booleanKey("watch-files", true);
    public static final ConfigKey<Boolean> SPLIT_STORAGE = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("split-storage.enabled", false));
    public static final ConfigKey<Map<SplitStorageType, StorageType>> SPLIT_STORAGE_OPTIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
        EnumMap<SplitStorageType, StorageType> map = new EnumMap<SplitStorageType, StorageType>(SplitStorageType.class);
        map.put(SplitStorageType.USER, StorageType.parse(c.getString("split-storage.methods.user", "h2"), StorageType.H2));
        map.put(SplitStorageType.GROUP, StorageType.parse(c.getString("split-storage.methods.group", "h2"), StorageType.H2));
        map.put(SplitStorageType.TRACK, StorageType.parse(c.getString("split-storage.methods.track", "h2"), StorageType.H2));
        map.put(SplitStorageType.UUID, StorageType.parse(c.getString("split-storage.methods.uuid", "h2"), StorageType.H2));
        map.put(SplitStorageType.LOG, StorageType.parse(c.getString("split-storage.methods.log", "h2"), StorageType.H2));
        return ImmutableMap.copyOf(map);
    }));
    public static final ConfigKey<String> MESSAGING_SERVICE = ConfigKeyTypes.enduringKey(ConfigKeyTypes.lowercaseStringKey("messaging-service", "auto"));
    public static final ConfigKey<Boolean> AUTO_PUSH_UPDATES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("auto-push-updates", true));
    public static final ConfigKey<Boolean> PUSH_LOG_ENTRIES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("push-log-entries", true));
    public static final ConfigKey<Boolean> BROADCAST_RECEIVED_LOG_ENTRIES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("broadcast-received-log-entries", false));
    public static final ConfigKey<Boolean> REDIS_ENABLED = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("redis.enabled", false));
    public static final ConfigKey<String> REDIS_ADDRESS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.stringKey("redis.address", null));
    public static final ConfigKey<String> REDIS_PASSWORD = ConfigKeyTypes.enduringKey(ConfigKeyTypes.stringKey("redis.password", ""));
    public static final ConfigKey<Boolean> REDIS_SSL = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("redis.ssl", false));
    public static final ConfigKey<String> BYTEBIN_URL = ConfigKeyTypes.stringKey("bytebin-url", "https://bytebin.lucko.me/");
    public static final ConfigKey<String> WEB_EDITOR_URL_PATTERN = ConfigKeyTypes.stringKey("web-editor-url", "https://editor.luckperms.net/");
    public static final ConfigKey<String> VERBOSE_VIEWER_URL_PATTERN = ConfigKeyTypes.stringKey("verbose-viewer-url", "https://luckperms.net/verbose/#");
    public static final ConfigKey<String> TREE_VIEWER_URL_PATTERN = ConfigKeyTypes.stringKey("tree-viewer-url", "https://luckperms.net/treeview/#");
    private static final List<ConfigKeyTypes.BaseConfigKey<?>> KEYS = (List)Arrays.stream(ConfigKeys.class.getFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> ConfigKey.class.equals(f.getType())).map(f -> {
        try {
            return (ConfigKeyTypes.BaseConfigKey)f.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }).collect(ImmutableCollectors.toList());

    private ConfigKeys() {
    }

    public static List<? extends ConfigKey<?>> getKeys() {
        return KEYS;
    }

    static {
        for (int i = 0; i < KEYS.size(); ++i) {
            ConfigKeys.KEYS.get((int)i).ordinal = i;
        }
    }
}

