/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.cache.ExpiringCache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ForwardingContextCalculator;
import me.lucko.luckperms.common.context.QueryOptionsSupplier;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.StaticContextCalculator;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ContextManager<S, P extends S> {
    protected final LuckPermsPlugin plugin;
    private final Class<S> subjectClass;
    private final Class<P> playerClass;
    private final List<ContextCalculator<? super S>> calculators = new CopyOnWriteArrayList<ContextCalculator<? super S>>();
    private final List<StaticContextCalculator> staticCalculators = new CopyOnWriteArrayList<StaticContextCalculator>();
    private final StaticLookupCache staticLookupCache = new StaticLookupCache();

    protected ContextManager(LuckPermsPlugin plugin, Class<S> subjectClass, Class<P> playerClass) {
        this.plugin = plugin;
        this.subjectClass = subjectClass;
        this.playerClass = playerClass;
    }

    public Class<S> getSubjectClass() {
        return this.subjectClass;
    }

    public Class<P> getPlayerClass() {
        return this.playerClass;
    }

    public abstract UUID getUniqueId(P var1);

    public abstract QueryOptionsSupplier getCacheFor(S var1);

    public QueryOptions getQueryOptions(S subject) {
        return this.getCacheFor(subject).getQueryOptions();
    }

    public ImmutableContextSet getContext(S subject) {
        return this.getCacheFor(subject).getContextSet();
    }

    public QueryOptions getStaticQueryOptions() {
        return (QueryOptions)this.staticLookupCache.get();
    }

    public ImmutableContextSet getStaticContext() {
        return this.getStaticQueryOptions().context();
    }

    public QueryOptions formQueryOptions(ImmutableContextSet contextSet) {
        return this.plugin.getConfiguration().get(ConfigKeys.GLOBAL_QUERY_OPTIONS).toBuilder().context(contextSet).build();
    }

    public abstract QueryOptions formQueryOptions(S var1, ImmutableContextSet var2);

    public abstract void invalidateCache(S var1);

    public void registerCalculator(ContextCalculator<? super S> calculator) {
        this.calculators.add(0, calculator);
        if (calculator instanceof StaticContextCalculator) {
            StaticContextCalculator staticCalculator = (StaticContextCalculator)calculator;
            this.staticCalculators.add(0, staticCalculator);
        }
    }

    public void unregisterCalculator(ContextCalculator<? super S> calculator) {
        this.calculators.remove(calculator);
        if (calculator instanceof StaticContextCalculator) {
            this.staticCalculators.remove(calculator);
        }
    }

    protected QueryOptions calculate(S subject) {
        ImmutableContextSetImpl.BuilderImpl accumulator = new ImmutableContextSetImpl.BuilderImpl();
        for (ContextCalculator<S> calculator : this.calculators) {
            try {
                calculator.calculate(subject, accumulator::add);
            }
            catch (Throwable e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst calculating the context of subject " + subject);
                e.printStackTrace();
            }
        }
        return this.formQueryOptions(subject, accumulator.build());
    }

    private QueryOptions calculateStatic() {
        ImmutableContextSetImpl.BuilderImpl accumulator = new ImmutableContextSetImpl.BuilderImpl();
        for (StaticContextCalculator calculator : this.staticCalculators) {
            try {
                calculator.calculate(accumulator::add);
            }
            catch (Throwable e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst calculating static contexts");
                e.printStackTrace();
            }
        }
        return this.formQueryOptions(accumulator.build());
    }

    public ImmutableContextSet getPotentialContexts() {
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        for (ContextCalculator<S> calculator : this.calculators) {
            ContextSet potentialContexts;
            try {
                potentialContexts = calculator.estimatePotentialContexts();
            }
            catch (Throwable e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst estimating potential contexts");
                e.printStackTrace();
                continue;
            }
            builder.addAll(potentialContexts);
        }
        return builder.build();
    }

    private static String getCalculatorClass(ContextCalculator<?> calculator) {
        Class<?> calculatorClass = calculator instanceof ForwardingContextCalculator ? ((ForwardingContextCalculator)calculator).delegate().getClass() : calculator.getClass();
        return calculatorClass.getName();
    }

    private final class StaticLookupCache
    extends ExpiringCache<QueryOptions> {
        StaticLookupCache() {
            super(50L, TimeUnit.MILLISECONDS);
        }

        @Override
        public @NonNull QueryOptions supply() {
            return ContextManager.this.calculateStatic();
        }
    }
}

