/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ImmutableContextSet;

public class ContextSetComparator
implements Comparator<ImmutableContextSet> {
    private static final Comparator<ImmutableContextSet> INSTANCE = new ContextSetComparator();
    private static final Comparator<ImmutableContextSet> REVERSE = INSTANCE.reversed();
    private static final Comparator<String> FAST_STRING_COMPARATOR = (o1, o2) -> o1 == o2 ? 0 : o1.compareTo((String)o2);
    private static final Comparator<Context> CONTEXT_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        int i = FAST_STRING_COMPARATOR.compare(o1.getKey(), o2.getKey());
        if (i != 0) {
            return i;
        }
        return FAST_STRING_COMPARATOR.compare(o1.getValue(), o2.getValue());
    };

    public static Comparator<ImmutableContextSet> normal() {
        return INSTANCE;
    }

    public static Comparator<ImmutableContextSet> reverse() {
        return REVERSE;
    }

    @Override
    public int compare(ImmutableContextSet o1, ImmutableContextSet o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Boolean.compare(o1.containsKey("server"), o2.containsKey("server"));
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o1.containsKey("world"), o2.containsKey("world"));
        if (result != 0) {
            return result;
        }
        result = Integer.compare(o1.size(), o2.size());
        if (result != 0) {
            return result;
        }
        ArrayList<Context> o1Entries = new ArrayList<Context>(o1.toSet());
        ArrayList<Context> o2Entries = new ArrayList<Context>(o2.toSet());
        o1Entries.sort(CONTEXT_COMPARATOR);
        o2Entries.sort(CONTEXT_COMPARATOR);
        Iterator it1 = o1Entries.iterator();
        Iterator it2 = o2Entries.iterator();
        while (it1.hasNext()) {
            Context ent2;
            Context ent1 = (Context)it1.next();
            result = CONTEXT_COMPARATOR.compare(ent1, ent2 = (Context)it2.next());
            if (result == 0) continue;
            return result;
        }
        throw new AssertionError((Object)("sets are equal? " + o1 + " - " + o2));
    }
}

