/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.contextset.MutableContextSetImpl;
import net.luckperms.api.context.ContextSet;

public final class ContextSetJsonSerializer {
    private ContextSetJsonSerializer() {
    }

    public static JsonObject serializeContextSet(ContextSet contextSet) {
        JsonObject data = new JsonObject();
        Map<String, Set<String>> map = contextSet.toMap();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            ArrayList values = new ArrayList(entry.getValue());
            int size = values.size();
            if (size == 1) {
                data.addProperty(entry.getKey(), (String)values.get(0));
                continue;
            }
            if (size <= 1) continue;
            JsonArray arr = new JsonArray();
            for (String s : values) {
                arr.add((JsonElement)new JsonPrimitive(s));
            }
            data.add(entry.getKey(), (JsonElement)arr);
        }
        return data;
    }

    public static ContextSet deserializeContextSet(Gson gson, String json) {
        Objects.requireNonNull(json, "json");
        if (json.equals("{}")) {
            return ImmutableContextSetImpl.EMPTY;
        }
        JsonObject context = (JsonObject)gson.fromJson(json, JsonObject.class);
        if (context == null) {
            return ImmutableContextSetImpl.EMPTY;
        }
        return ContextSetJsonSerializer.deserializeContextSet((JsonElement)context);
    }

    public static ContextSet deserializeContextSet(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject data = element.getAsJsonObject();
        if (data.entrySet().isEmpty()) {
            return ImmutableContextSetImpl.EMPTY;
        }
        MutableContextSetImpl map = new MutableContextSetImpl();
        for (Map.Entry e : data.entrySet()) {
            String k = (String)e.getKey();
            JsonElement v = (JsonElement)e.getValue();
            if (v.isJsonArray()) {
                JsonArray values = v.getAsJsonArray();
                for (JsonElement value : values) {
                    map.add(k, value.getAsString());
                }
                continue;
            }
            map.add(k, v.getAsString());
        }
        return map;
    }
}

