/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.StaticContextCalculator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LPStaticContextsCalculator
implements StaticContextCalculator {
    private final LuckPermsConfiguration config;

    public LPStaticContextsCalculator(LuckPermsConfiguration config) {
        this.config = config;
    }

    @Override
    public void calculate(@NonNull ContextConsumer consumer) {
        String server = this.config.get(ConfigKeys.SERVER);
        if (!server.equals("global")) {
            consumer.accept("server", server);
        }
        consumer.accept(this.config.getContextsFile().getStaticContexts());
    }

    @Override
    public ContextSet estimatePotentialContexts() {
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        this.calculate(builder::add);
        return builder.build();
    }
}

