/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.contextset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import me.lucko.luckperms.common.context.contextset.AbstractContextSet;
import me.lucko.luckperms.common.context.contextset.ContextImpl;
import me.lucko.luckperms.common.context.contextset.MutableContextSetImpl;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.MutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ImmutableContextSetImpl
extends AbstractContextSet
implements ImmutableContextSet {
    public static final ImmutableContextSetImpl EMPTY = new ImmutableContextSetImpl((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of());
    private final ImmutableSetMultimap<String, String> map;
    private final int hashCode;

    public static ImmutableContextSet of(String key, String value) {
        return new ImmutableContextSetImpl((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of((Object)ImmutableContextSetImpl.sanitizeKey(key), (Object)ImmutableContextSetImpl.sanitizeValue(value)));
    }

    ImmutableContextSetImpl(ImmutableSetMultimap<String, String> contexts) {
        this.map = contexts;
        this.hashCode = this.map.hashCode();
    }

    @Override
    protected SetMultimap<String, String> backing() {
        return this.map;
    }

    @Override
    protected void copyTo(SetMultimap<String, String> other) {
        other.putAll(this.map);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    @Deprecated
    public @NonNull ImmutableContextSetImpl immutableCopy() {
        return this;
    }

    @Override
    public @NonNull MutableContextSet mutableCopy() {
        return new MutableContextSetImpl((SetMultimap<String, String>)this.map);
    }

    @Override
    public @NonNull Set<Context> toSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet entries = this.map.entries();
        for (Map.Entry e : entries) {
            builder.add((Object)new ContextImpl((String)e.getKey(), (String)e.getValue()));
        }
        return builder.build();
    }

    @Override
    public @NonNull Map<String, Set<String>> toMap() {
        return Multimaps.asMap(this.map);
    }

    @Override
    @Deprecated
    public @NonNull Map<String, String> toFlattenedMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    private ImmutableList<Context> toList() {
        ImmutableSet entries = this.map.entries();
        Object[] array = new Context[entries.size()];
        int i = 0;
        for (Map.Entry e : entries) {
            array[i++] = new ContextImpl((String)e.getKey(), (String)e.getValue());
        }
        return ImmutableList.copyOf((Object[])array);
    }

    @Override
    public @NonNull Iterator<Context> iterator() {
        return this.toList().iterator();
    }

    @Override
    public Spliterator<Context> spliterator() {
        return this.toList().spliterator();
    }

    @Override
    public boolean isSatisfiedBy(@NonNull ContextSet other) {
        if (this == other) {
            return true;
        }
        Objects.requireNonNull(other, "other");
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (this.size() > other.size()) {
            return false;
        }
        ImmutableSet entries = this.map.entries();
        for (Map.Entry e : entries) {
            if (other.contains((String)e.getKey(), (String)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        ImmutableSetMultimap thatBacking;
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet that = (ContextSet)o;
        if (that instanceof ImmutableContextSetImpl) {
            ImmutableContextSetImpl immutableThat = (ImmutableContextSetImpl)that;
            if (this.hashCode != immutableThat.hashCode) {
                return false;
            }
        }
        if (that instanceof AbstractContextSet) {
            thatBacking = ((AbstractContextSet)that).backing();
        } else {
            Map<String, Set<String>> thatMap = that.toMap();
            ImmutableSetMultimap.Builder thatBuilder = ImmutableSetMultimap.builder();
            for (Map.Entry<String, Set<String>> e : thatMap.entrySet()) {
                thatBuilder.putAll((Object)e.getKey(), (Iterable)e.getValue());
            }
            thatBacking = thatBuilder.build();
        }
        return this.backing().equals(thatBacking);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ImmutableContextSet(contexts=" + this.map + ")";
    }

    public static final class BuilderImpl
    implements ImmutableContextSet.Builder {
        private ImmutableSetMultimap.Builder<String, String> builder;

        private synchronized ImmutableSetMultimap.Builder<String, String> builder() {
            if (this.builder == null) {
                this.builder = ImmutableSetMultimap.builder();
            }
            return this.builder;
        }

        private void put(String key, String value) {
            this.builder().put((Object)key, (Object)value);
        }

        @Override
        public @NonNull BuilderImpl add(@NonNull String key, @NonNull String value) {
            this.put(AbstractContextSet.sanitizeKey(key), AbstractContextSet.sanitizeValue(value));
            return this;
        }

        @Override
        public @NonNull BuilderImpl addAll(@NonNull ContextSet contextSet) {
            Objects.requireNonNull(contextSet, "contextSet");
            if (contextSet instanceof AbstractContextSet) {
                AbstractContextSet other = (AbstractContextSet)contextSet;
                if (!other.isEmpty()) {
                    this.builder().putAll(other.backing());
                }
            } else {
                this.addAll(contextSet.toSet());
            }
            return this;
        }

        @Override
        public @NonNull ImmutableContextSet build() {
            if (this.builder == null) {
                return EMPTY;
            }
            return new ImmutableContextSetImpl((ImmutableSetMultimap<String, String>)this.builder.build());
        }
    }
}

