/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.contextset;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import me.lucko.luckperms.common.context.contextset.AbstractContextSet;
import me.lucko.luckperms.common.context.contextset.ContextImpl;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.MutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MutableContextSetImpl
extends AbstractContextSet
implements MutableContextSet {
    private final SetMultimap<String, String> map;

    public MutableContextSetImpl() {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    MutableContextSetImpl(SetMultimap<String, String> other) {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(other));
    }

    @Override
    protected SetMultimap<String, String> backing() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyTo(SetMultimap<String, String> other) {
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            other.putAll(this.map);
        }
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ImmutableContextSet immutableCopy() {
        if (this.map.isEmpty()) {
            return ImmutableContextSetImpl.EMPTY;
        }
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            return new ImmutableContextSetImpl((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.copyOf(this.map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull MutableContextSetImpl mutableCopy() {
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            return new MutableContextSetImpl(this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ImmutableSet<Context> toSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set entries = this.map.entries();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : entries) {
                builder.add((Object)new ContextImpl((String)e.getKey(), (String)e.getValue()));
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Map<String, Set<String>> toMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map map = this.map.asMap();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : map.entrySet()) {
                builder.put(e.getKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)e.getValue())));
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public @NonNull Map<String, String> toFlattenedMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set entries = this.map.entries();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : entries) {
                builder.put(e.getKey(), e.getValue());
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableList<Context> toList() {
        Object[] array;
        Set entries = this.map.entries();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            array = new Context[entries.size()];
            int i = 0;
            for (Map.Entry e : entries) {
                array[i++] = new ContextImpl((String)e.getKey(), (String)e.getValue());
            }
        }
        return ImmutableList.copyOf((Object[])array);
    }

    @Override
    public @NonNull Iterator<Context> iterator() {
        return this.toList().iterator();
    }

    @Override
    public Spliterator<Context> spliterator() {
        return this.toList().spliterator();
    }

    @Override
    public void add(@NonNull String key, @NonNull String value) {
        this.map.put((Object)MutableContextSetImpl.sanitizeKey(key), (Object)MutableContextSetImpl.sanitizeValue(value));
    }

    @Override
    public void addAll(@NonNull ContextSet contextSet) {
        Objects.requireNonNull(contextSet, "contextSet");
        if (contextSet instanceof AbstractContextSet) {
            AbstractContextSet other = (AbstractContextSet)contextSet;
            other.copyTo(this.map);
        } else {
            this.addAll(contextSet.toSet());
        }
    }

    @Override
    public void remove(@NonNull String key, @NonNull String value) {
        this.map.remove((Object)MutableContextSetImpl.sanitizeKey(key), (Object)MutableContextSetImpl.sanitizeValue(value));
    }

    @Override
    public void removeAll(@NonNull String key) {
        this.map.removeAll((Object)MutableContextSetImpl.sanitizeKey(key));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSatisfiedBy(@NonNull ContextSet other) {
        if (this == other) {
            return true;
        }
        Objects.requireNonNull(other, "other");
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (this.size() > other.size()) {
            return false;
        }
        Set entries = this.map.entries();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : entries) {
                if (other.contains((String)e.getKey(), (String)e.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        ImmutableSetMultimap thatBacking;
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet that = (ContextSet)o;
        if (that instanceof AbstractContextSet) {
            thatBacking = ((AbstractContextSet)that).backing();
        } else {
            Map<String, Set<String>> thatMap = that.toMap();
            ImmutableSetMultimap.Builder thatBuilder = ImmutableSetMultimap.builder();
            for (Map.Entry<String, Set<String>> e : thatMap.entrySet()) {
                thatBuilder.putAll((Object)e.getKey(), (Iterable)e.getValue());
            }
            thatBacking = thatBuilder.build();
        }
        return this.backing().equals(thatBacking);
    }

    public String toString() {
        return "MutableContextSet(contexts=" + this.map + ")";
    }
}

