/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies;

import com.google.common.collect.ImmutableList;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import me.lucko.luckperms.common.dependencies.relocation.Relocation;
import me.lucko.luckperms.common.dependencies.relocation.RelocationHelper;

public enum Dependency {
    ASM("org.ow2.asm", "asm", "7.1", "SrL6K20sycyx6qBeoynEB7R7E+0pFfYvjEuMyWJY1N4="),
    ASM_COMMONS("org.ow2.asm", "asm-commons", "7.1", "5VkEidjxmE2Fv+q9Oxc3TFnCiuCdSOxKDrvQGVns01g="),
    JAR_RELOCATOR("me.lucko", "jar-relocator", "1.4", "1RsiF3BiVztjlfTA+svDCuoDSGFuSpTZYHvUK8yBx8I="),
    TEXT("net{}kyori", "text-api", "3.0.3", "/EP/woKCSL0wKQ59zrGx6xPrByI9tY9BPHklf5NNHws=", Relocation.of("text", "net{}kyori{}text")),
    TEXT_SERIALIZER_GSON("net{}kyori", "text-serializer-gson", "3.0.3", "WmOA7vIcGR679MQxIe6Bw7gbWxUEpGabwKsAumzHApw=", Relocation.of("text", "net{}kyori{}text")),
    TEXT_SERIALIZER_LEGACY("net{}kyori", "text-serializer-legacy", "3.0.3", "Ug2Ji/0FWxKLUssfOgkIZ2UWcAptdTm8KxM8ObAoNIU=", Relocation.of("text", "net{}kyori{}text")),
    TEXT_ADAPTER_BUKKIT("net{}kyori", "text-adapter-bukkit", "3.0.3", "K1ib03ajCNm7CkVjX42o+Mg6M+eUaAfo29CBvfu+++o=", Relocation.of("text", "net{}kyori{}text")),
    TEXT_ADAPTER_BUNGEECORD("net{}kyori", "text-adapter-bungeecord", "3.0.3", "klLpz+PWAoZzR+nyxUu6ohFKtrGya8tq/lWU6GfSVGY=", Relocation.of("text", "net{}kyori{}text")),
    TEXT_ADAPTER_SPONGEAPI("net{}kyori", "text-adapter-spongeapi", "3.0.3", "tRHQOThbp3ECZB0WbrgPZdKmvNA28K9bBwoshGWpTFQ=", Relocation.of("text", "net{}kyori{}text")),
    EVENT("net{}kyori", "event-api", "3.0.0", "yjvdTdAyktl3iFEQFLHC3qYwwt7/DbCd7Zc8Q4SlIag=", Relocation.of("eventbus", "net{}kyori{}event")),
    CAFFEINE("com{}github{}ben-manes{}caffeine", "caffeine", "2.8.1", "H2fbGQaw2xx+DXnAv+NH+wTwSWCYgymUZUsS73nfoak=", Relocation.of("caffeine", "com{}github{}benmanes{}caffeine")),
    OKIO("com{}squareup{}" + RelocationHelper.OKIO_STRING, RelocationHelper.OKIO_STRING, "1.17.5", "Gaf/SNhtPPRJf38lD78pX0MME6Uo3Vt7ID+CGAK4hq0=", Relocation.of(RelocationHelper.OKIO_STRING, RelocationHelper.OKIO_STRING)),
    OKHTTP("com{}squareup{}" + RelocationHelper.OKHTTP3_STRING, "okhttp", "3.14.7", "Yg1PpDxcal72JXYCBKiHmeHkpl4ceh2NoC4GHEy7gAA=", Relocation.of(RelocationHelper.OKHTTP3_STRING, RelocationHelper.OKHTTP3_STRING), Relocation.of(RelocationHelper.OKIO_STRING, RelocationHelper.OKIO_STRING)),
    BYTEBUDDY("net{}bytebuddy", "byte-buddy", "1.10.9", "B7nKbi+XDLA/SyVlHfHy/OJx1JG0TgQJgniHeG9pLU0=", Relocation.of("bytebuddy", "net{}bytebuddy")),
    COMMODORE("me{}lucko", "commodore", "1.7", "ncwmvNFfvyZf1Pa0v4fWyMR0Jxe1v1ZgXOiI255IX5Q=", Relocation.of("commodore", "me{}lucko{}commodore")),
    MARIADB_DRIVER("org{}mariadb{}jdbc", "mariadb-java-client", "2.6.0", "fgiCp29Z7X38ULAJNsxZ1wFIVT2u3trSx/VCMxTlA6g=", Relocation.of("mariadb", "org{}mariadb{}jdbc")),
    MYSQL_DRIVER("mysql", "mysql-connector-java", "5.1.48", "VuJsqqOCH1rkr0T5x09mz4uE6gFRatOAPLsOkEm27Kg=", Relocation.of("mysql", "com{}mysql")),
    POSTGRESQL_DRIVER("org{}postgresql", "postgresql", "9.4.1212", "DLKhWL4xrPIY4KThjI89usaKO8NIBkaHc/xECUsMNl0=", Relocation.of("postgresql", "org{}postgresql")),
    H2_DRIVER("com.h2database", "h2", "1.4.199", "MSWhZ0O8a0z7thq7p4MgPx+2gjCqD9yXiY95b5ml1C4="),
    SQLITE_DRIVER("org.xerial", "sqlite-jdbc", "3.28.0", "k3hOVtv1RiXgbJks+D9w6cG93Vxq0dPwEwjIex2WG2A="),
    HIKARI("com{}zaxxer", "HikariCP", "3.4.2", "rnp2e/N8l5JSPtPtcitG6M8jYPVG9iUOuYyDNVrWl/k=", Relocation.of("hikari", "com{}zaxxer{}hikari")),
    SLF4J_SIMPLE("org.slf4j", "slf4j-simple", "1.7.30", "i5J5y/9rn4hZTvrjzwIDm2mVAw7sAj7UOSh0jEFnD+4="),
    SLF4J_API("org.slf4j", "slf4j-api", "1.7.30", "zboHlk0btAoHYUhcax6ML4/Z6x0ZxTkorA1/lRAQXFc="),
    MONGODB_DRIVER("org.mongodb", "mongo-java-driver", "3.12.2", "eMxHcEtasb/ubFCv99kE5rVZMPGmBei674ZTdjYe58w=", Relocation.of("mongodb", "com{}mongodb"), Relocation.of("bson", "org{}bson")),
    JEDIS("redis.clients", "jedis", "3.3.0", "HuTfz9xW/mi1fwVQ3xgPmd6qwTRMF/3fyMzw2LmOgy4=", Relocation.of("jedis", "redis{}clients{}jedis"), Relocation.of("commonspool2", "org{}apache{}commons{}pool2")),
    COMMONS_POOL_2("org.apache.commons", "commons-pool2", "2.8.0", "Xvqfu1SlixoSIFpfrFZfaYKr/rD/Rb28MYdI71/To/8=", Relocation.of("commonspool2", "org{}apache{}commons{}pool2")),
    CONFIGURATE_CORE("me{}lucko{}configurate", "configurate-core", "3.5", "J+1WnX1g5gr4ne8qA7DuBadLDOsZnOZjwHbdRmVgF6c=", Relocation.of("configurate", "ninja{}leaping{}configurate")),
    CONFIGURATE_GSON("me{}lucko{}configurate", "configurate-gson", "3.5", "Q3wp3xpqy41bJW3yUhbHOzm+NUkT4bUUBI2/AQLaa3c=", Relocation.of("configurate", "ninja{}leaping{}configurate")),
    CONFIGURATE_YAML("me{}lucko{}configurate", "configurate-yaml", "3.5", "Dxr1o3EPbpOOmwraqu+cors8O/nKwJnhS5EiPkTb3fc=", Relocation.of("configurate", "ninja{}leaping{}configurate")),
    SNAKEYAML("org.yaml", "snakeyaml", "1.23", "EwCfte3jzyvlqNDxYCFVrqoM5e9fk2aJK9JY2NPU0rE=", Relocation.of("yaml", "org{}yaml{}snakeyaml")),
    CONFIGURATE_HOCON("me{}lucko{}configurate", "configurate-hocon", "3.5", "sOym1KPmQylGSfk90ZFqobuvoZfEWb7XMmMBwbHuxFw=", Relocation.of("configurate", "ninja{}leaping{}configurate"), Relocation.of("hocon", "com{}typesafe{}config")),
    HOCON_CONFIG("com{}typesafe", "config", "1.3.3", "tfHWBx8VSNBb6C9Z+QOcfTeheHvY48Z34x7ida9KRiE=", Relocation.of("hocon", "com{}typesafe{}config")),
    CONFIGURATE_TOML("me{}lucko{}configurate", "configurate-toml", "3.5", "U8p0XSTaNT/uebvLpO/vb6AhVGQDYiZsauSGB9zolPU=", Relocation.of("configurate", "ninja{}leaping{}configurate"), Relocation.of("toml4j", "com{}moandjiezana{}toml")),
    TOML4J("com{}moandjiezana{}toml", "toml4j", "0.7.2", "9UdeY+fonl22IiNImux6Vr0wNUN3IHehfCy1TBnKOiA=", Relocation.of("toml4j", "com{}moandjiezana{}toml"));

    private final String mavenRepoPath;
    private final String version;
    private final byte[] checksum;
    private final List<Relocation> relocations;
    private static final String MAVEN_FORMAT = "%s/%s/%s/%s-%s.jar";

    private Dependency(String groupId, String artifactId, String version, String checksum) {
        this(groupId, artifactId, version, checksum, new Relocation[0]);
    }

    private Dependency(String groupId, String artifactId, String version, String checksum, Relocation ... relocations) {
        this.mavenRepoPath = String.format(MAVEN_FORMAT, Dependency.rewriteEscaping(groupId).replace(".", "/"), Dependency.rewriteEscaping(artifactId), version, Dependency.rewriteEscaping(artifactId), version);
        this.version = version;
        this.checksum = Base64.getDecoder().decode(checksum);
        this.relocations = ImmutableList.copyOf((Object[])relocations);
    }

    private static String rewriteEscaping(String s) {
        return s.replace("{}", ".");
    }

    public String getFileName() {
        return this.name().toLowerCase().replace('_', '-') + "-" + this.version;
    }

    String getMavenRepoPath() {
        return this.mavenRepoPath;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public boolean checksumMatches(byte[] hash) {
        return Arrays.equals(this.checksum, hash);
    }

    public List<Relocation> getRelocations() {
        return this.relocations;
    }

    public static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

