/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.DependencyDownloadException;

public enum DependencyRepository {
    LUCK_MIRROR("https://nexus.lucko.me/repository/maven-central/"){

        @Override
        protected URLConnection openConnection(Dependency dependency) throws IOException {
            URLConnection connection = super.openConnection(dependency);
            connection.setRequestProperty("User-Agent", "luckperms");
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L));
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(10L));
            return connection;
        }
    }
    ,
    MAVEN_CENTRAL("https://repo1.maven.org/maven2/");

    private final String url;

    private DependencyRepository(String url) {
        this.url = url;
    }

    protected URLConnection openConnection(Dependency dependency) throws IOException {
        URL dependencyUrl = new URL(this.url + dependency.getMavenRepoPath());
        return dependencyUrl.openConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] downloadRaw(Dependency dependency) throws DependencyDownloadException {
        try {
            URLConnection connection = this.openConnection(dependency);
            try (InputStream in = connection.getInputStream();){
                byte[] bytes = ByteStreams.toByteArray((InputStream)in);
                if (bytes.length == 0) {
                    throw new DependencyDownloadException("Empty stream");
                }
                byte[] byArray = bytes;
                return byArray;
            }
        }
        catch (Exception e) {
            throw new DependencyDownloadException(e);
        }
    }

    public byte[] download(Dependency dependency) throws DependencyDownloadException {
        byte[] bytes = this.downloadRaw(dependency);
        byte[] hash = Dependency.createDigest().digest(bytes);
        if (!dependency.checksumMatches(hash)) {
            throw new DependencyDownloadException("Downloaded file had an invalid hash. Expected: " + Base64.getEncoder().encodeToString(dependency.getChecksum()) + " Actual: " + Base64.getEncoder().encodeToString(hash));
        }
        return bytes;
    }

    public void download(Dependency dependency, Path file) throws DependencyDownloadException {
        try {
            Files.write(file, this.download(dependency), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DependencyDownloadException(e);
        }
    }
}

