/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies.classloader;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import me.lucko.luckperms.common.dependencies.classloader.PluginClassLoader;
import me.lucko.luckperms.common.plugin.bootstrap.LuckPermsBootstrap;

public class ReflectionClassLoader
implements PluginClassLoader {
    private final URLClassLoader classLoader;
    private final Supplier<Method> addUrlMethod;

    public ReflectionClassLoader(LuckPermsBootstrap bootstrap) throws IllegalStateException {
        ClassLoader classLoader = bootstrap.getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalStateException("ClassLoader is not instance of URLClassLoader");
        }
        this.classLoader = (URLClassLoader)classLoader;
        this.addUrlMethod = Suppliers.memoize(() -> {
            if (ReflectionClassLoader.isJava9OrNewer()) {
                bootstrap.getPluginLogger().info("It is safe to ignore any warning printed following this message starting with 'WARNING: An illegal reflective access operation has occurred, Illegal reflective access by " + this.getClass().getName() + "'. This is intended, and will not have any impact on the operation of LuckPerms.");
            }
            try {
                Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addUrlMethod.setAccessible(true);
                return addUrlMethod;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void addJarToClasspath(Path file) {
        try {
            ((Method)this.addUrlMethod.get()).invoke((Object)this.classLoader, file.toUri().toURL());
        }
        catch (IllegalAccessException | InvocationTargetException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isJava9OrNewer() {
        try {
            Runtime.class.getMethod("version", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

