/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import me.lucko.luckperms.common.api.implementation.ApiPermissionHolder;
import me.lucko.luckperms.common.cacheddata.GroupCachedDataManager;
import me.lucko.luckperms.common.cacheddata.UserCachedDataManager;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.common.event.gen.GeneratedEventClass;
import me.lucko.luckperms.common.event.model.EntitySourceImpl;
import me.lucko.luckperms.common.event.model.SenderPlatformEntity;
import me.lucko.luckperms.common.event.model.UnknownSource;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.sender.Sender;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.event.LuckPermsEvent;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.event.cause.DeletionCause;
import net.luckperms.api.event.extension.ExtensionLoadEvent;
import net.luckperms.api.event.group.GroupCacheLoadEvent;
import net.luckperms.api.event.group.GroupCreateEvent;
import net.luckperms.api.event.group.GroupDataRecalculateEvent;
import net.luckperms.api.event.group.GroupDeleteEvent;
import net.luckperms.api.event.group.GroupLoadAllEvent;
import net.luckperms.api.event.group.GroupLoadEvent;
import net.luckperms.api.event.log.LogBroadcastEvent;
import net.luckperms.api.event.log.LogNetworkPublishEvent;
import net.luckperms.api.event.log.LogNotifyEvent;
import net.luckperms.api.event.log.LogPublishEvent;
import net.luckperms.api.event.log.LogReceiveEvent;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.event.player.PlayerDataSaveEvent;
import net.luckperms.api.event.player.PlayerLoginProcessEvent;
import net.luckperms.api.event.source.Source;
import net.luckperms.api.event.sync.ConfigReloadEvent;
import net.luckperms.api.event.sync.PostSyncEvent;
import net.luckperms.api.event.sync.PreNetworkSyncEvent;
import net.luckperms.api.event.sync.PreSyncEvent;
import net.luckperms.api.event.track.TrackCreateEvent;
import net.luckperms.api.event.track.TrackDeleteEvent;
import net.luckperms.api.event.track.TrackLoadAllEvent;
import net.luckperms.api.event.track.TrackLoadEvent;
import net.luckperms.api.event.track.mutate.TrackAddGroupEvent;
import net.luckperms.api.event.track.mutate.TrackClearEvent;
import net.luckperms.api.event.track.mutate.TrackRemoveGroupEvent;
import net.luckperms.api.event.type.Cancellable;
import net.luckperms.api.event.user.UserCacheLoadEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.luckperms.api.event.user.UserFirstLoginEvent;
import net.luckperms.api.event.user.UserLoadEvent;
import net.luckperms.api.event.user.track.UserDemoteEvent;
import net.luckperms.api.event.user.track.UserPromoteEvent;
import net.luckperms.api.extension.Extension;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EventDispatcher {
    private final AbstractEventBus<?> eventBus;

    public EventDispatcher(AbstractEventBus<?> eventBus) {
        this.eventBus = eventBus;
    }

    public AbstractEventBus<?> getEventBus() {
        return this.eventBus;
    }

    private boolean shouldPost(Class<? extends LuckPermsEvent> eventClass) {
        return this.eventBus.shouldPost(eventClass);
    }

    private void post(LuckPermsEvent event) {
        this.eventBus.post(event);
    }

    private <T extends LuckPermsEvent> void post(Class<T> eventClass, Supplier<T> supplier) {
        if (Cancellable.class.isAssignableFrom(eventClass)) {
            throw new RuntimeException("Cancellable event cannot be posted async (" + eventClass + ")");
        }
        this.eventBus.getPlugin().getBootstrap().getScheduler().executeAsync(() -> {
            if (!this.shouldPost(eventClass)) {
                return;
            }
            LuckPermsEvent event = (LuckPermsEvent)supplier.get();
            this.post(event);
        });
    }

    private <T extends LuckPermsEvent> T generate(Class<T> eventClass, Object ... params) {
        try {
            return (T)GeneratedEventClass.generate(eventClass).newInstance(this.eventBus.getApiProvider(), params);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception occurred whilst generating event instance", e);
        }
    }

    public void dispatchExtensionLoad(Extension extension) {
        this.post(ExtensionLoadEvent.class, () -> this.generate(ExtensionLoadEvent.class, extension));
    }

    public void dispatchGroupCacheLoad(Group group, GroupCachedDataManager data) {
        this.post(GroupCacheLoadEvent.class, () -> this.generate(GroupCacheLoadEvent.class, group.getApiProxy(), data));
    }

    public void dispatchGroupCreate(Group group, CreationCause cause) {
        this.post(GroupCreateEvent.class, () -> this.generate(GroupCreateEvent.class, new Object[]{group.getApiProxy(), cause}));
    }

    public void dispatchGroupDelete(Group group, DeletionCause cause) {
        this.post(GroupDeleteEvent.class, () -> this.generate(GroupDeleteEvent.class, new Object[]{group.getName(), ImmutableSet.copyOf((Collection)group.normalData().immutable().values()), cause}));
    }

    public void dispatchGroupLoadAll() {
        this.post(GroupLoadAllEvent.class, () -> this.generate(GroupLoadAllEvent.class, new Object[0]));
    }

    public void dispatchGroupLoad(Group group) {
        this.post(GroupLoadEvent.class, () -> this.generate(GroupLoadEvent.class, group.getApiProxy()));
    }

    public boolean dispatchLogBroadcast(boolean initialState, Action entry, LogBroadcastEvent.Origin origin) {
        if (!this.shouldPost(LogBroadcastEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogBroadcastEvent.class, new Object[]{cancel, entry, origin}));
        return cancel.get();
    }

    public boolean dispatchLogPublish(boolean initialState, Action entry) {
        if (!this.shouldPost(LogPublishEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogPublishEvent.class, cancel, entry));
        return cancel.get();
    }

    public boolean dispatchLogNetworkPublish(boolean initialState, UUID id, Action entry) {
        if (!this.shouldPost(LogNetworkPublishEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogNetworkPublishEvent.class, cancel, id, entry));
        return cancel.get();
    }

    public boolean dispatchLogNotify(boolean initialState, Action entry, LogNotifyEvent.Origin origin, Sender sender) {
        if (!this.shouldPost(LogNotifyEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogNotifyEvent.class, new Object[]{cancel, entry, origin, new SenderPlatformEntity(sender)}));
        return cancel.get();
    }

    public void dispatchLogReceive(UUID id, Action entry) {
        this.post(LogReceiveEvent.class, () -> this.generate(LogReceiveEvent.class, id, entry));
    }

    public void dispatchNodeAdd(Node node, PermissionHolder target, DataType dataType, Collection<? extends Node> before, Collection<? extends Node> after) {
        this.post(NodeAddEvent.class, () -> this.generate(NodeAddEvent.class, new Object[]{EventDispatcher.proxy(target), dataType, ImmutableSet.copyOf((Collection)before), ImmutableSet.copyOf((Collection)after), node}));
    }

    public void dispatchNodeClear(PermissionHolder target, DataType dataType, Collection<? extends Node> before, Collection<? extends Node> after) {
        this.post(NodeClearEvent.class, () -> this.generate(NodeClearEvent.class, new Object[]{EventDispatcher.proxy(target), dataType, ImmutableSet.copyOf((Collection)before), ImmutableSet.copyOf((Collection)after)}));
    }

    public void dispatchNodeRemove(Node node, PermissionHolder target, DataType dataType, Collection<? extends Node> before, Collection<? extends Node> after) {
        this.post(NodeRemoveEvent.class, () -> this.generate(NodeRemoveEvent.class, new Object[]{EventDispatcher.proxy(target), dataType, ImmutableSet.copyOf((Collection)before), ImmutableSet.copyOf((Collection)after), node}));
    }

    public void dispatchConfigReload() {
        this.post(ConfigReloadEvent.class, () -> this.generate(ConfigReloadEvent.class, new Object[0]));
    }

    public void dispatchPostSync() {
        this.post(PostSyncEvent.class, () -> this.generate(PostSyncEvent.class, new Object[0]));
    }

    public boolean dispatchNetworkPreSync(boolean initialState, UUID id) {
        if (!this.shouldPost(PreNetworkSyncEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(PreNetworkSyncEvent.class, cancel, id));
        return cancel.get();
    }

    public boolean dispatchPreSync(boolean initialState) {
        if (!this.shouldPost(PreSyncEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(PreSyncEvent.class, cancel));
        return cancel.get();
    }

    public void dispatchTrackCreate(Track track, CreationCause cause) {
        this.post(TrackCreateEvent.class, () -> this.generate(TrackCreateEvent.class, new Object[]{track.getApiProxy(), cause}));
    }

    public void dispatchTrackDelete(Track track, DeletionCause cause) {
        this.post(TrackDeleteEvent.class, () -> this.generate(TrackDeleteEvent.class, new Object[]{track.getName(), ImmutableList.copyOf(track.getGroups()), cause}));
    }

    public void dispatchTrackLoadAll() {
        this.post(TrackLoadAllEvent.class, () -> this.generate(TrackLoadAllEvent.class, new Object[0]));
    }

    public void dispatchTrackLoad(Track track) {
        this.post(TrackLoadEvent.class, () -> this.generate(TrackLoadEvent.class, track.getApiProxy()));
    }

    public void dispatchTrackAddGroup(Track track, String group, List<String> before, List<String> after) {
        this.post(TrackAddGroupEvent.class, () -> this.generate(TrackAddGroupEvent.class, track.getApiProxy(), ImmutableList.copyOf((Collection)before), ImmutableList.copyOf((Collection)after), group));
    }

    public void dispatchTrackClear(Track track, List<String> before) {
        this.post(TrackClearEvent.class, () -> this.generate(TrackClearEvent.class, track.getApiProxy(), ImmutableList.copyOf((Collection)before), ImmutableList.of()));
    }

    public void dispatchTrackRemoveGroup(Track track, String group, List<String> before, List<String> after) {
        this.post(TrackRemoveGroupEvent.class, () -> this.generate(TrackRemoveGroupEvent.class, track.getApiProxy(), ImmutableList.copyOf((Collection)before), ImmutableList.copyOf((Collection)after), group));
    }

    public void dispatchUserCacheLoad(User user, UserCachedDataManager data) {
        this.post(UserCacheLoadEvent.class, () -> this.generate(UserCacheLoadEvent.class, user.getApiProxy(), data));
    }

    public void dispatchDataRecalculate(PermissionHolder holder) {
        if (holder.getType() == HolderType.USER) {
            User user = (User)holder;
            this.post(UserDataRecalculateEvent.class, () -> this.generate(UserDataRecalculateEvent.class, user.getApiProxy(), user.getCachedData()));
        } else {
            Group group = (Group)holder;
            this.post(GroupDataRecalculateEvent.class, () -> this.generate(GroupDataRecalculateEvent.class, group.getApiProxy(), group.getCachedData()));
        }
    }

    public void dispatchUserFirstLogin(UUID uniqueId, String username) {
        this.post(UserFirstLoginEvent.class, () -> this.generate(UserFirstLoginEvent.class, uniqueId, username));
    }

    public void dispatchPlayerLoginProcess(UUID uniqueId, String username, User user) {
        if (!this.shouldPost(PlayerLoginProcessEvent.class)) {
            return;
        }
        this.post(this.generate(PlayerLoginProcessEvent.class, uniqueId, username, user.getApiProxy()));
    }

    public void dispatchPlayerDataSave(UUID uniqueId, String username, PlayerSaveResult result) {
        this.post(PlayerDataSaveEvent.class, () -> this.generate(PlayerDataSaveEvent.class, uniqueId, username, result));
    }

    public void dispatchUserLoad(User user) {
        this.post(UserLoadEvent.class, () -> this.generate(UserLoadEvent.class, user.getApiProxy()));
    }

    public void dispatchUserDemote(User user, Track track, String from, String to, @Nullable Sender source) {
        this.post(UserDemoteEvent.class, () -> {
            Source s = source == null ? UnknownSource.INSTANCE : new EntitySourceImpl(new SenderPlatformEntity(source));
            return this.generate(UserDemoteEvent.class, s, track.getApiProxy(), user.getApiProxy(), Optional.ofNullable(from), Optional.ofNullable(to));
        });
    }

    public void dispatchUserPromote(User user, Track track, String from, String to, @Nullable Sender source) {
        this.post(UserPromoteEvent.class, () -> {
            Source s = source == null ? UnknownSource.INSTANCE : new EntitySourceImpl(new SenderPlatformEntity(source));
            return this.generate(UserPromoteEvent.class, s, track.getApiProxy(), user.getApiProxy(), Optional.ofNullable(from), Optional.ofNullable(to));
        });
    }

    private static ApiPermissionHolder proxy(PermissionHolder holder) {
        if (holder instanceof Group) {
            return ((Group)holder).getApiProxy();
        }
        if (holder instanceof User) {
            return ((User)holder).getApiProxy();
        }
        throw new AssertionError();
    }
}

